/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.OpenGaussCommandPacketType;
import org.apache.shardingsphere.db.protocol.opengauss.packet.command.query.extended.bind.OpenGaussComBatchBindPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLAggregatedCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.simple.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.query.extended.bind.OpenGaussComBatchBindExecutor;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.query.simple.OpenGaussComQueryExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.generic.PostgreSQLComTerminationExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.generic.PostgreSQLUnsupportedCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLAggregatedBatchedStatementsCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLAggregatedCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.bind.PostgreSQLComBindExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.close.PostgreSQLComCloseExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.describe.PostgreSQLComDescribeExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.execute.PostgreSQLComExecuteExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.parse.PostgreSQLComParseExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.sync.PostgreSQLComSyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussCommandExecutorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussCommandExecutorFactory.class);

    public static CommandExecutor newInstance(CommandPacketType commandPacketType, PostgreSQLCommandPacket commandPacket, ConnectionSession connectionSession, PostgreSQLConnectionContext connectionContext) throws SQLException {
        log.debug("Execute packet type: {}, value: {}", (Object)commandPacketType, (Object)commandPacket);
        if (!(commandPacket instanceof PostgreSQLAggregatedCommandPacket)) {
            return OpenGaussCommandExecutorFactory.getCommandExecutor(commandPacketType, commandPacket, connectionSession, connectionContext);
        }
        PostgreSQLAggregatedCommandPacket aggregatedCommandPacket = (PostgreSQLAggregatedCommandPacket)commandPacket;
        if (aggregatedCommandPacket.isContainsBatchedStatements() && aggregatedCommandPacket.getPackets().stream().noneMatch(each -> each instanceof OpenGaussComBatchBindPacket)) {
            return new PostgreSQLAggregatedCommandExecutor(OpenGaussCommandExecutorFactory.getExecutorsOfAggregatedBatchedStatements(aggregatedCommandPacket, connectionSession, connectionContext));
        }
        ArrayList<CommandExecutor> result = new ArrayList<CommandExecutor>(aggregatedCommandPacket.getPackets().size());
        for (PostgreSQLCommandPacket each2 : aggregatedCommandPacket.getPackets()) {
            result.add(OpenGaussCommandExecutorFactory.getCommandExecutor((CommandPacketType)each2.getIdentifier(), each2, connectionSession, connectionContext));
        }
        return new PostgreSQLAggregatedCommandExecutor(result);
    }

    private static List<CommandExecutor> getExecutorsOfAggregatedBatchedStatements(PostgreSQLAggregatedCommandPacket aggregatedCommandPacket, ConnectionSession connectionSession, PostgreSQLConnectionContext connectionContext) throws SQLException {
        PostgreSQLCommandPacket each;
        int i;
        List packets = aggregatedCommandPacket.getPackets();
        int firstBindIndex = aggregatedCommandPacket.getFirstBindIndex();
        int lastExecuteIndex = aggregatedCommandPacket.getLastExecuteIndex();
        ArrayList<CommandExecutor> result = new ArrayList<CommandExecutor>(firstBindIndex + packets.size() - lastExecuteIndex);
        for (i = 0; i < firstBindIndex; ++i) {
            each = (PostgreSQLCommandPacket)packets.get(i);
            result.add(OpenGaussCommandExecutorFactory.getCommandExecutor((CommandPacketType)each.getIdentifier(), each, connectionSession, connectionContext));
        }
        result.add((CommandExecutor)new PostgreSQLAggregatedBatchedStatementsCommandExecutor(connectionSession, packets.subList(firstBindIndex, lastExecuteIndex + 1)));
        for (i = lastExecuteIndex + 1; i < packets.size(); ++i) {
            each = (PostgreSQLCommandPacket)packets.get(i);
            result.add(OpenGaussCommandExecutorFactory.getCommandExecutor((CommandPacketType)each.getIdentifier(), each, connectionSession, connectionContext));
        }
        return result;
    }

    private static CommandExecutor getCommandExecutor(CommandPacketType commandPacketType, PostgreSQLCommandPacket commandPacket, ConnectionSession connectionSession, PostgreSQLConnectionContext connectionContext) throws SQLException {
        if (OpenGaussCommandPacketType.BATCH_BIND_COMMAND == commandPacketType) {
            return new OpenGaussComBatchBindExecutor((OpenGaussComBatchBindPacket)commandPacket, connectionSession);
        }
        switch ((PostgreSQLCommandPacketType)commandPacketType) {
            case SIMPLE_QUERY: {
                return new OpenGaussComQueryExecutor(connectionContext, (PostgreSQLComQueryPacket)commandPacket, connectionSession);
            }
            case PARSE_COMMAND: {
                return new PostgreSQLComParseExecutor((PostgreSQLComParsePacket)commandPacket, connectionSession);
            }
            case BIND_COMMAND: {
                return new PostgreSQLComBindExecutor(connectionContext, (PostgreSQLComBindPacket)commandPacket, connectionSession);
            }
            case DESCRIBE_COMMAND: {
                return new PostgreSQLComDescribeExecutor(connectionContext, (PostgreSQLComDescribePacket)commandPacket, connectionSession);
            }
            case EXECUTE_COMMAND: {
                return new PostgreSQLComExecuteExecutor(connectionContext, (PostgreSQLComExecutePacket)commandPacket);
            }
            case SYNC_COMMAND: {
                return new PostgreSQLComSyncExecutor(connectionSession);
            }
            case CLOSE_COMMAND: {
                return new PostgreSQLComCloseExecutor(connectionContext, (PostgreSQLComClosePacket)commandPacket, connectionSession);
            }
            case TERMINATE: {
                return new PostgreSQLComTerminationExecutor();
            }
        }
        return new PostgreSQLUnsupportedCommandExecutor();
    }

    @Generated
    private OpenGaussCommandExecutorFactory() {
    }
}

