/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.command.query.simple;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLEmptyQueryResponsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.simple.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.ClientEncodingResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.exception.InvalidParameterValueException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackStatement;

public final class OpenGaussComQueryExecutor
implements QueryCommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private volatile ResponseType responseType;

    public OpenGaussComQueryExecutor(PostgreSQLConnectionContext connectionContext, PostgreSQLComQueryPacket comQueryPacket, ConnectionSession connectionSession) throws SQLException {
        this.connectionContext = connectionContext;
        this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeFactory.getInstance((String)"openGauss"), (String)comQueryPacket.getSql(), Optional::empty, (ConnectionSession)connectionSession);
    }

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        ResponseHeader responseHeader = this.textProtocolBackendHandler.execute();
        if (responseHeader instanceof QueryResponseHeader) {
            return Collections.singleton(this.createRowDescriptionPacket((QueryResponseHeader)responseHeader));
        }
        this.responseType = ResponseType.UPDATE;
        return responseHeader instanceof UpdateResponseHeader ? Collections.singleton(this.createUpdatePacket((UpdateResponseHeader)responseHeader)) : this.createClientEncodingPackets((ClientEncodingResponseHeader)responseHeader);
    }

    private PostgreSQLRowDescriptionPacket createRowDescriptionPacket(QueryResponseHeader queryResponseHeader) {
        Collection<PostgreSQLColumnDescription> columnDescriptions = this.createColumnDescriptions(queryResponseHeader);
        this.responseType = ResponseType.QUERY;
        return new PostgreSQLRowDescriptionPacket(columnDescriptions.size(), columnDescriptions);
    }

    private Collection<PostgreSQLColumnDescription> createColumnDescriptions(QueryResponseHeader queryResponseHeader) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponseHeader.getQueryHeaders()) {
            result.add(new PostgreSQLColumnDescription(each.getColumnLabel(), ++columnIndex, each.getColumnType(), each.getColumnLength(), each.getColumnTypeName()));
        }
        return result;
    }

    private PostgreSQLPacket createUpdatePacket(UpdateResponseHeader updateResponseHeader) {
        SQLStatement sqlStatement = updateResponseHeader.getSqlStatement();
        if (sqlStatement instanceof CommitStatement || sqlStatement instanceof RollbackStatement) {
            this.connectionContext.closeAllPortals();
        }
        return sqlStatement instanceof EmptyStatement ? new PostgreSQLEmptyQueryResponsePacket() : new PostgreSQLCommandCompletePacket(PostgreSQLCommand.valueOf((Class)sqlStatement.getClass()).map(PostgreSQLCommand::getTag).orElse(""), updateResponseHeader.getUpdateCount());
    }

    private Collection<DatabasePacket<?>> createClientEncodingPackets(ClientEncodingResponseHeader clientEncodingResponseHeader) {
        LinkedList result = new LinkedList();
        Optional currentCharsetValue = clientEncodingResponseHeader.getCurrentCharsetValue();
        if (currentCharsetValue.isPresent()) {
            result.add((DatabasePacket<?>)new PostgreSQLCommandCompletePacket("SET", 0L));
            result.add((DatabasePacket<?>)new PostgreSQLParameterStatusPacket("client_encoding", (String)currentCharsetValue.get()));
            return result;
        }
        throw new InvalidParameterValueException(String.format("invalid value for parameter \"clientEncoding\": \"%s\"", clientEncodingResponseHeader.getInputValue()));
    }

    public boolean next() throws SQLException {
        return this.textProtocolBackendHandler.next();
    }

    public PostgreSQLPacket getQueryRowPacket() throws SQLException {
        return new PostgreSQLDataRowPacket(this.textProtocolBackendHandler.getRowData());
    }

    public void close() throws SQLException {
        this.textProtocolBackendHandler.close();
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

