/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.sql.common.constant.Paren;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLCacheIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLChecksumTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLFlushStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLInstallPluginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLKillStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLLoadIndexInfoStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLOptimizeTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLRepairTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLResetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLUninstallPluginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLUseStatement;

public final class SQLUtil {
    private static final String SQL_END = ";";
    private static final String COMMENT_PREFIX = "/*";
    private static final String COMMENT_SUFFIX = "*/";
    private static final String EXCLUDED_CHARACTERS = "[]`'\"";
    private static final Pattern SINGLE_CHARACTER_PATTERN = Pattern.compile("^_|([^\\\\])_");
    private static final Pattern SINGLE_CHARACTER_ESCAPE_PATTERN = Pattern.compile("\\\\_");
    private static final Pattern ANY_CHARACTER_PATTERN = Pattern.compile("^%|([^\\\\])%");
    private static final Pattern ANY_CHARACTER_ESCAPE_PATTERN = Pattern.compile("\\\\%");

    public static Number getExactlyNumber(String value, int radix) {
        try {
            return SQLUtil.getBigInteger(value, radix);
        }
        catch (NumberFormatException ex) {
            return new BigDecimal(value);
        }
    }

    private static Number getBigInteger(String value, int radix) {
        BigInteger result = new BigInteger(value, radix);
        if (result.compareTo(new BigInteger(String.valueOf(Integer.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Integer.MAX_VALUE))) <= 0) {
            return result.intValue();
        }
        if (result.compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) <= 0) {
            return result.longValue();
        }
        return result;
    }

    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)EXCLUDED_CHARACTERS).removeFrom((CharSequence)value);
    }

    public static String getExactlyValue(String value, String reservedCharacters) {
        if (null == value) {
            return null;
        }
        String toBeExcludedCharacters = CharMatcher.anyOf((CharSequence)reservedCharacters).removeFrom((CharSequence)EXCLUDED_CHARACTERS);
        return CharMatcher.anyOf((CharSequence)toBeExcludedCharacters).removeFrom((CharSequence)value);
    }

    public static String getExactlyExpression(String value) {
        return Strings.isNullOrEmpty((String)value) ? value : CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)value);
    }

    public static String getExpressionWithoutOutsideParentheses(String value) {
        int parenthesesOffset = SQLUtil.getParenthesesOffset(value);
        return 0 == parenthesesOffset ? value : value.substring(parenthesesOffset, value.length() - parenthesesOffset);
    }

    private static int getParenthesesOffset(String value) {
        int result = 0;
        if (Strings.isNullOrEmpty((String)value)) {
            return result;
        }
        while (Paren.PARENTHESES.getLeftParen() == value.charAt(result)) {
            ++result;
        }
        return result;
    }

    public static List<SubqueryTableSegment> getSubqueryTableSegmentFromTableSegment(TableSegment tableSegment) {
        LinkedList<SubqueryTableSegment> result = new LinkedList<SubqueryTableSegment>();
        if (tableSegment instanceof SubqueryTableSegment) {
            result.add((SubqueryTableSegment)tableSegment);
        }
        if (tableSegment instanceof JoinTableSegment) {
            result.addAll(SQLUtil.getSubqueryTableSegmentFromJoinTableSegment((JoinTableSegment)tableSegment));
        }
        return result;
    }

    private static List<SubqueryTableSegment> getSubqueryTableSegmentFromJoinTableSegment(JoinTableSegment joinTableSegment) {
        LinkedList<SubqueryTableSegment> result = new LinkedList<SubqueryTableSegment>();
        if (joinTableSegment.getLeft() instanceof SubqueryTableSegment) {
            result.add((SubqueryTableSegment)joinTableSegment.getLeft());
        } else if (joinTableSegment.getLeft() instanceof JoinTableSegment) {
            result.addAll(SQLUtil.getSubqueryTableSegmentFromJoinTableSegment((JoinTableSegment)joinTableSegment.getLeft()));
        }
        if (joinTableSegment.getRight() instanceof SubqueryTableSegment) {
            result.add((SubqueryTableSegment)joinTableSegment.getRight());
        } else if (joinTableSegment.getRight() instanceof JoinTableSegment) {
            result.addAll(SQLUtil.getSubqueryTableSegmentFromJoinTableSegment((JoinTableSegment)joinTableSegment.getRight()));
        }
        return result;
    }

    public static boolean isReadOnly(SQLStatement sqlStatement) {
        if (sqlStatement instanceof DMLStatement) {
            return SQLUtil.isReadOnly((DMLStatement)sqlStatement);
        }
        if (sqlStatement instanceof DALStatement) {
            return SQLUtil.isReadOnly((DALStatement)sqlStatement);
        }
        if (sqlStatement instanceof DDLStatement) {
            return false;
        }
        if (sqlStatement instanceof DCLStatement) {
            return false;
        }
        throw new UnsupportedOperationException(String.format("Unsupported SQL Type `%s`", sqlStatement.getClass().getSimpleName()));
    }

    private static boolean isReadOnly(DMLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return true;
        }
        if (sqlStatement instanceof UpdateStatement || sqlStatement instanceof DeleteStatement || sqlStatement instanceof InsertStatement) {
            return false;
        }
        throw new UnsupportedOperationException(String.format("Unsupported SQL Type `%s`", sqlStatement.getClass().getSimpleName()));
    }

    private static boolean isReadOnly(DALStatement sqlStatement) {
        return !(sqlStatement instanceof SetStatement | sqlStatement instanceof MySQLUseStatement | sqlStatement instanceof MySQLUninstallPluginStatement | sqlStatement instanceof MySQLResetStatement | sqlStatement instanceof MySQLRepairTableStatement | sqlStatement instanceof MySQLOptimizeTableStatement | sqlStatement instanceof MySQLLoadIndexInfoStatement | sqlStatement instanceof MySQLKillStatement | sqlStatement instanceof MySQLInstallPluginStatement | sqlStatement instanceof MySQLFlushStatement | sqlStatement instanceof MySQLChecksumTableStatement | sqlStatement instanceof MySQLCacheIndexStatement);
    }

    public static ExpressionSegment createLiteralExpression(ASTNode astNode, int startIndex, int stopIndex, String text) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(startIndex, stopIndex, ((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(startIndex, stopIndex, ((OtherLiteralValue)astNode).getValue());
        }
        return new CommonExpressionSegment(startIndex, stopIndex, text);
    }

    public static String trimSemicolon(String sql) {
        return sql.endsWith(SQL_END) ? sql.substring(0, sql.length() - 1) : sql;
    }

    public static String trimComment(String sql) {
        String result = sql;
        if (sql.startsWith(COMMENT_PREFIX)) {
            result = result.substring(sql.indexOf(COMMENT_SUFFIX) + 2);
        }
        if (sql.endsWith(SQL_END)) {
            result = result.substring(0, result.length() - 1);
        }
        return result.trim();
    }

    public static String convertLikePatternToRegex(String pattern) {
        String result = pattern;
        if (pattern.contains("_")) {
            result = SINGLE_CHARACTER_PATTERN.matcher(result).replaceAll("$1.");
            result = SINGLE_CHARACTER_ESCAPE_PATTERN.matcher(result).replaceAll("_");
        }
        if (pattern.contains("%")) {
            result = ANY_CHARACTER_PATTERN.matcher(result).replaceAll("$1.*");
            result = ANY_CHARACTER_ESCAPE_PATTERN.matcher(result).replaceAll("%");
        }
        return result;
    }

    @Generated
    private SQLUtil() {
    }
}

