/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo;

import java.awt.Color;
import java.awt.event.WindowListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.engine.classic.demo.util.DefaultCloseHandler;
import org.pentaho.reporting.engine.classic.demo.util.DemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class HelloWorld
implements DemoHandler {
    protected void executeReport() {
        MasterReport report = this.createReportDefinition();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.createData()));
        PreviewDialog preview = new PreviewDialog(report);
        preview.addWindowListener((WindowListener)new DefaultCloseHandler());
        preview.pack();
        preview.setVisible(true);
    }

    private TableModel createData() {
        Object[] columnNames = new String[]{"Column1", "Column2"};
        DefaultTableModel result = new DefaultTableModel(columnNames, 1);
        result.setValueAt("Hello\n", 0, 0);
        result.setValueAt("World!\n", 0, 1);
        return result;
    }

    private MasterReport createReportDefinition() {
        MasterReport report = new MasterReport();
        report.setName(this.getDescription());
        TextFieldElementFactory factory = new TextFieldElementFactory();
        factory.setName("T1");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(150.0f, 12.0f));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.RIGHT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setNullString("-");
        factory.setFieldname("Column1");
        report.getItemBand().addElement(factory.createElement());
        factory = new TextFieldElementFactory();
        factory.setName("T2");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(200.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(150.0f, 12.0f));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setNullString("-");
        factory.setFieldname("Column2");
        report.getItemBand().addElement(factory.createElement());
        return report;
    }

    protected String getDescription() {
        return "A Very Simple Report";
    }

    @Override
    public String getDemoName() {
        return "Hello World Demo (External)";
    }

    @Override
    public PreviewHandler getPreviewHandler() {
        return new HelloWorldPreviewHandler();
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        new HelloWorld().executeReport();
    }

    private class HelloWorldPreviewHandler
    implements PreviewHandler {
        protected HelloWorldPreviewHandler() {
        }

        @Override
        public void attemptPreview() {
            HelloWorld.this.executeReport();
        }
    }
}

