/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.chartdemo;

import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class MultiSimpleXmlChartDemo
extends AbstractXmlDemoHandler {
    private TableModel data = this.createTableModel();

    private TableModel createTableModel() {
        Object[][] data = new Object[12][];
        for (int i = 0; i < 12; ++i) {
            data[i] = new Object[]{this.createChart(i + 1995)};
        }
        Object[] colNames = new String[]{"Chart"};
        return new DefaultTableModel(data, colNames);
    }

    @Override
    public String getDemoName() {
        return "Multiple JFreeChart Demo (Simple-XML)";
    }

    private PieDataset createSampleDataset() {
        DefaultPieDataset result = new DefaultPieDataset();
        result.setValue((Comparable)((Object)"Java"), (Number)new Integer((int)(Math.random() * 200.0)));
        result.setValue((Comparable)((Object)"Visual Basic"), (Number)new Integer((int)(Math.random() * 50.0)));
        result.setValue((Comparable)((Object)"C/C++"), (Number)new Integer((int)(Math.random() * 100.0)));
        result.setValue((Comparable)((Object)"PHP"), (Number)new Integer((int)(Math.random() * 50.0)));
        result.setValue((Comparable)((Object)"Perl"), (Number)new Integer((int)(Math.random() * 100.0)));
        return result;
    }

    private JFreeChart createChart(int year) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)("Programming Language of the Year " + year), (PieDataset)this.createSampleDataset(), (boolean)true, (boolean)true, (boolean)false);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setStartAngle(270.0);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        return chart;
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"multi-chart.html", MultiSimpleXmlChartDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"multi-chart-simple.xml", MultiSimpleXmlChartDemo.class);
    }
}

