/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.chartdemo;

import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.chartdemo.MultiSimpleXmlChartDemo;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class TableJFreeChartDemo
extends AbstractXmlDemoHandler {
    private TableModel data = this.createTableModel();

    @Override
    public String getDemoName() {
        return "Table And JFreeChart Demo (Simple-XML)";
    }

    private PieDataset createSampleDataset(int[] votes) {
        DefaultPieDataset result = new DefaultPieDataset();
        result.setValue((Comparable)((Object)"Java"), (Number)new Integer(votes[0]));
        result.setValue((Comparable)((Object)"Visual Basic"), (Number)new Integer(votes[1]));
        result.setValue((Comparable)((Object)"C/C++"), (Number)new Integer(votes[2]));
        result.setValue((Comparable)((Object)"PHP"), (Number)new Integer(votes[3]));
        result.setValue((Comparable)((Object)"Perl"), (Number)new Integer(votes[4]));
        return result;
    }

    private JFreeChart createChart(int year, int[] votes) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)("Programming Language of the Year " + year), (PieDataset)this.createSampleDataset(votes), (boolean)true, (boolean)true, (boolean)false);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setStartAngle(270.0);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        return chart;
    }

    private TableModel createTableModel() {
        Object[][] data = new Object[60][];
        int[] votes = new int[5];
        for (int i = 0; i < 12; ++i) {
            Integer year = new Integer(1995 + i);
            votes[0] = (int)(Math.random() * 200.0);
            votes[1] = (int)(Math.random() * 50.0);
            votes[2] = (int)(Math.random() * 100.0);
            votes[3] = (int)(Math.random() * 50.0);
            votes[4] = (int)(Math.random() * 100.0);
            JFreeChart chart = this.createChart(year, votes);
            data[i * 5] = new Object[]{year, "Java", new Integer(votes[0]), chart};
            data[i * 5 + 1] = new Object[]{year, "Visual Basic", new Integer(votes[1]), chart};
            data[i * 5 + 2] = new Object[]{year, "C/C++", new Integer(votes[2]), chart};
            data[i * 5 + 3] = new Object[]{year, "PHP", new Integer(votes[3]), chart};
            data[i * 5 + 4] = new Object[]{year, "Perl", new Integer(votes[4]), chart};
        }
        Object[] colNames = new String[]{"year", "language", "votes", "chart"};
        return new DefaultTableModel(data, colNames);
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"table-chart.html", MultiSimpleXmlChartDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"table-chart-simple.xml", MultiSimpleXmlChartDemo.class);
    }
}

