/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.FormValidator;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.LengthLimitingDocument;
import org.pentaho.reporting.engine.classic.demo.util.DemoController;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class CSVUserInputPanel
extends JPanel {
    public static final String RESOURCE_BASE = "org.pentaho.reporting.engine.classic.demo.resources.demo-resources";
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String TAB_SEPARATOR = "\t";
    private static final String CSV_FILE_EXTENSION = ".csv";
    private JTextArea txDataArea;
    private JCheckBox cbxColumnNamesAsFirstRow;
    private JRadioButton rbSeparatorTab;
    private JRadioButton rbSeparatorColon;
    private JRadioButton rbSeparatorSemicolon;
    private JRadioButton rbSeparatorOther;
    private JTextField txSeparatorOther;
    private FormValidator formValidator;
    private DemoController controller;
    private ResourceBundleSupport resources;
    private JFileChooser fileChooser;

    public CSVUserInputPanel(DemoController controler) {
        this.controller = controler;
        this.resources = new ResourceBundleSupport(Locale.getDefault(), RESOURCE_BASE, ObjectUtilities.getClassLoader(CSVUserInputPanel.class));
        this.formValidator = new CSVDialogValidator();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createDataArea(), "Center");
        this.add((Component)this.createSeparatorPanel(), "South");
    }

    private JComponent createDataArea() {
        this.txDataArea = new JTextArea();
        this.cbxColumnNamesAsFirstRow = new JCheckBox("First Row contains Column-Names");
        JLabel lbDataArea = new JLabel("CSV-Data");
        JLabel lbLoadData = new JLabel("Load Data from File");
        JButton btLoadData = new JButton(new LoadCSVDataAction());
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        dataPanel.add((Component)lbDataArea, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        dataPanel.add((Component)this.txDataArea, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        dataPanel.add((Component)lbLoadData, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        dataPanel.add((Component)btLoadData, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        dataPanel.add((Component)this.cbxColumnNamesAsFirstRow, gbc);
        this.formValidator.registerButton((AbstractButton)this.cbxColumnNamesAsFirstRow);
        return dataPanel;
    }

    public DemoController getController() {
        return this.controller;
    }

    protected boolean performValidate() {
        JStatusBar statusBar = this.controller.getStatusBar();
        statusBar.clear();
        return true;
    }

    protected FormValidator getFormValidator() {
        return this.formValidator;
    }

    private JPanel createSeparatorPanel() {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.resources.getString("csvdemodialog.separatorchar"));
        separatorPanel.setBorder(tb);
        this.rbSeparatorTab = new JRadioButton(this.resources.getString("csvdemodialog.separator.tab"));
        this.rbSeparatorColon = new JRadioButton(this.resources.getString("csvdemodialog.separator.colon"));
        this.rbSeparatorSemicolon = new JRadioButton(this.resources.getString("csvdemodialog.separator.semicolon"));
        this.rbSeparatorOther = new JRadioButton(this.resources.getString("csvdemodialog.separator.other"));
        this.getFormValidator().registerButton((AbstractButton)this.rbSeparatorColon);
        this.getFormValidator().registerButton((AbstractButton)this.rbSeparatorOther);
        this.getFormValidator().registerButton((AbstractButton)this.rbSeparatorSemicolon);
        this.getFormValidator().registerButton((AbstractButton)this.rbSeparatorTab);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbSeparatorTab);
        btg.add(this.rbSeparatorColon);
        btg.add(this.rbSeparatorSemicolon);
        btg.add(this.rbSeparatorOther);
        ActionSelectSeparator selectAction = new ActionSelectSeparator();
        this.rbSeparatorTab.addActionListener(selectAction);
        this.rbSeparatorColon.addActionListener(selectAction);
        this.rbSeparatorSemicolon.addActionListener(selectAction);
        this.rbSeparatorOther.addActionListener(selectAction);
        LengthLimitingDocument ldoc = new LengthLimitingDocument(1);
        this.txSeparatorOther = new JTextField();
        this.txSeparatorOther.setDocument((Document)ldoc);
        this.getFormValidator().registerTextField((JTextComponent)this.txSeparatorOther);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorTab, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorColon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorSemicolon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorOther, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.txSeparatorOther, gbc);
        return separatorPanel;
    }

    protected void performSeparatorSelection() {
        if (this.rbSeparatorOther.isSelected()) {
            this.txSeparatorOther.setEnabled(true);
        } else {
            this.txSeparatorOther.setEnabled(false);
        }
    }

    public boolean isColumnNamesAsFirstRow() {
        return this.cbxColumnNamesAsFirstRow.isSelected();
    }

    public void setColumnNamesAsFirstRow(boolean colsAsFirstRow) {
        this.cbxColumnNamesAsFirstRow.setSelected(colsAsFirstRow);
    }

    protected void performLoadFile() {
        int option;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.addChoosableFileFilter((FileFilter)new FilesystemFilter(CSV_FILE_EXTENSION, this.resources.getString("csvdemodialog.csv-file-description")));
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        if ((option = this.fileChooser.showOpenDialog(this)) == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            try {
                BufferedReader in = new BufferedReader(new FileReader(selFile));
                StringWriter out = new StringWriter((int)selFile.length());
                IOUtils.getInstance().copyWriter((Reader)in, (Writer)out);
                in.close();
                this.txDataArea.setText(out.toString());
            }
            catch (IOException ioe) {
                this.controller.getStatusBar().setStatusText("Failed to load CSV file: " + ioe.getLocalizedMessage());
            }
        }
    }

    public String getData() {
        return this.txDataArea.getText();
    }

    public String getSeparatorString() {
        if (this.rbSeparatorColon.isSelected()) {
            return COMMA_SEPARATOR;
        }
        if (this.rbSeparatorSemicolon.isSelected()) {
            return SEMICOLON_SEPARATOR;
        }
        if (this.rbSeparatorTab.isSelected()) {
            return TAB_SEPARATOR;
        }
        if (this.rbSeparatorOther.isSelected()) {
            return this.txSeparatorOther.getText();
        }
        return "";
    }

    public void setSeparatorString(String s) {
        if (s == null) {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText("");
        } else if (s.equals(COMMA_SEPARATOR)) {
            this.rbSeparatorColon.setSelected(true);
        } else if (s.equals(SEMICOLON_SEPARATOR)) {
            this.rbSeparatorSemicolon.setSelected(true);
        } else if (s.equals(TAB_SEPARATOR)) {
            this.rbSeparatorTab.setSelected(true);
        } else {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText(s);
        }
        this.performSeparatorSelection();
    }

    private class LoadCSVDataAction
    extends AbstractAction {
        protected LoadCSVDataAction() {
            this.putValue("Name", "Select");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVUserInputPanel.this.performLoadFile();
        }
    }

    private class CSVDialogValidator
    extends FormValidator {
        protected CSVDialogValidator() {
        }

        public boolean performValidate() {
            return CSVUserInputPanel.this.performValidate();
        }

        public Action getConfirmAction() {
            return CSVUserInputPanel.this.getController().getExportAction();
        }
    }

    private class ActionSelectSeparator
    extends AbstractAction {
        protected ActionSelectSeparator() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVUserInputPanel.this.performSeparatorSelection();
        }
    }
}

