/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;

public class FontTableModel
extends AbstractTableModel {
    private Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();

    public FontTableModel() {
        Arrays.sort(this.fonts, new FontComparator());
    }

    @Override
    public int getRowCount() {
        return this.fonts.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "family";
        }
        if (column == 1) {
            return "fontname";
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.fonts[row].getFamily();
        }
        if (column == 1) {
            return this.fonts[row].getName();
        }
        throw new IndexOutOfBoundsException();
    }

    private static class FontComparator
    implements Comparator {
        public int compare(Object o, Object o1) {
            Font f1 = (Font)o;
            Font f2 = (Font)o1;
            int comp = f1.getFamily().compareTo(f2.getFamily());
            if (comp == 0) {
                comp = f1.getName().compareTo(f2.getName());
            }
            return comp;
        }
    }
}

