/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.form;

import java.awt.Window;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.form.Patient;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.form.PatientTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.form.Treatment;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class SimplePatientFormDemo
extends AbstractXmlDemoHandler {
    private PatientTableModel data;
    private GregorianCalendar calendar = new GregorianCalendar();

    public SimplePatientFormDemo() {
        Patient johnDoe = new Patient("John Doe", "12 Nowhere Road", "Anytown", "1234-5678-AB12", "Greedy Health Care Corp.", "Symptoms - Weeping and RSI caused by hours of tearing up holiday photos. \nCause - Someone richer, younger and thinner than the patient. \nDiagnostics - Broken Heart Disease");
        johnDoe.addTreament(new Treatment(this.createDate(12, 10, 1999), "Initial consulting of the doctor", "-", "done"));
        johnDoe.addTreament(new Treatment(this.createDate(12, 10, 1999), "X-Ray the patients chest", "-", "done"));
        johnDoe.addTreament(new Treatment(this.createDate(12, 10, 1999), "Psychiatrist consulting", "-", "failed"));
        johnDoe.addTreament(new Treatment(this.createDate(12, 10, 1999), "2nd X-Ray scan", "-", "done"));
        johnDoe.addTreament(new Treatment(this.createDate(12, 10, 1999), "Two Surgeons open the chest and gently mend the heart whilst holding their breath.", "anesthetics", "sucess"));
        johnDoe.setLevel("totally healed");
        Patient kane = new Patient("Kane, (First name not known)", "United States commercial starship Nostromo", "-", "4637-1345-NO123", "Aurora Mining Corp.", "Cause - Face huggers equipped with intelligent alien blood.\nSymptoms - Gradual alien metamorphosis and desire to destroy our cities. \nDiagnostics - Alien DNA");
        kane.addTreament(new Treatment(this.createDate(12, 10, 1999), "Initial consulting of the doctor", "-", "failure"));
        kane.addTreament(new Treatment(this.createDate(12, 10, 1999), "X-Ray Scan", "-", "failure"));
        kane.addTreament(new Treatment(this.createDate(12, 10, 1999), "mechanically removing the DNA , cleaning of alien elements and replacing quickly with clean DNA.", "-", "success"));
        kane.addTreament(new Treatment(this.createDate(12, 10, 1999), "balanced diet", "-", "failed"));
        kane.setAllergy("fast food");
        kane.setLevel("Alien escaped and killed the patient.");
        this.data = new PatientTableModel();
        this.data.addPatient(johnDoe);
        this.data.addPatient(kane);
    }

    private Date createDate(int year, int month, int day) {
        this.calendar.clear();
        this.calendar.set(year, month - 1, day);
        return this.calendar.getTime();
    }

    @Override
    public String getDemoName() {
        return "Patient Form Demo";
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"form.html", SimplePatientFormDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"patient.xml", SimplePatientFormDemo.class);
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)this.data));
        return report;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        SimplePatientFormDemo handler = new SimplePatientFormDemo();
        SimpleDemoFrame frame = new SimpleDemoFrame(handler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

