/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.internationalisation;

import java.awt.Window;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.internationalisation.LocaleUpdatePreviewHandler;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class I18nDemo
extends AbstractXmlDemoHandler {
    private TableModel data = I18nDemo.createData();

    @Override
    public String getDemoName() {
        return "Internationalisation Demo";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"i18n.html", I18nDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"i18n.xml", I18nDemo.class);
    }

    public static TableModel createData() {
        DefaultTableModel data = new DefaultTableModel();
        data.addColumn("Data");
        data.addColumn("A");
        data.addColumn("B");
        data.addColumn("C");
        data.addRow(new Object[]{"data.firstElement", new Double(43.0), new Double(127.5), new Double(10001.999)});
        data.addRow(new Object[]{"data.secondElement", new Double(57.0), new Double(108.5), new Double(-10001.999)});
        data.addRow(new Object[]{"data.thirdElement", new Double(35.0), new Double(164.8), new Double(-999.9999)});
        data.addRow(new Object[]{"data.fourthElement", new Double(86.0), new Double(164.0), new Double(999.9999)});
        data.addRow(new Object[]{"data.lastElement", new Double(12.0), new Double(103.2), new Double(0.999)});
        return data;
    }

    @Override
    public PreviewHandler getPreviewHandler() {
        return new LocaleUpdatePreviewHandler(this);
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        I18nDemo handler = new I18nDemo();
        SimpleDemoFrame frame = new SimpleDemoFrame(handler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

