/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.internationalisation;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.DefaultReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;

public class LocaleSelectionReportController
extends DefaultReportController {
    private static final Log logger = LogFactory.getLog(LocaleSelectionReportController.class);
    private KeyedComboBoxModel localesModel;
    private PreviewPane previewPane;

    public LocaleSelectionReportController() {
        UpdateAction updateAction = new UpdateAction();
        this.localesModel = this.createLocalesModel();
        JComboBox cbx = new JComboBox(this.localesModel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add(new JLabel("Select locale:"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add(cbx, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 13;
        this.add(new JButton(updateAction));
    }

    private KeyedComboBoxModel createLocalesModel() {
        KeyedComboBoxModel cn = new KeyedComboBoxModel();
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            cn.add((Object)locale, (Object)locale.getDisplayName());
        }
        cn.setSelectedKey((Object)Locale.getDefault());
        return cn;
    }

    public Locale getSelectedLocale() {
        Locale l = (Locale)this.localesModel.getSelectedKey();
        if (l == null) {
            return Locale.getDefault();
        }
        return l;
    }

    public void setSelectedLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.localesModel.setSelectedKey((Object)locale);
    }

    public void initialize(PreviewPane pane) {
        super.initialize(pane);
        this.previewPane = pane;
    }

    public void deinitialize(PreviewPane pane) {
        super.deinitialize(pane);
        this.previewPane = null;
    }

    public PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    private class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
            this.putValue("Name", "Update");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewPane base = LocaleSelectionReportController.this.getPreviewPane();
            if (base == null) {
                return;
            }
            MasterReport report = base.getReportJob();
            DefaultResourceBundleFactory rfact = new DefaultResourceBundleFactory(LocaleSelectionReportController.this.getSelectedLocale());
            report.setResourceBundleFactory((ResourceBundleFactory)rfact);
            try {
                base.setReportJob(report);
            }
            catch (Exception ex) {
                logger.error((Object)"Unable to refresh the report.", (Throwable)ex);
            }
        }
    }
}

