/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Advertising;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Article;

public class AdvertisingTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"advertise", "customer.firstName", "customer.lastName", "customer.street", "customer.town", "customer.postalCode", "customer.country", "customer.salutation", "ad.date", "ad.number", "article.name", "article.number", "article.details", "article.price", "article.reducedPrice"};
    private static Class[] COLUMN_TYPES = new Class[]{Advertising.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Date.class, String.class, String.class, String.class, String.class, Float.class, Double.class};
    private transient Advertising[] adPerRow;
    private transient Article[] articlesPerRow;
    private transient double[] reducedPricePerRow;
    private ArrayList advertisings = new ArrayList();
    private int totalSize;

    public void addAdvertising(Advertising advertising) {
        this.advertisings.add(advertising);
        this.invalidateCaches();
        this.fireTableDataChanged();
    }

    public void removeAdvertising(Advertising advertising) {
        this.advertisings.remove(advertising);
        this.invalidateCaches();
        this.fireTableDataChanged();
    }

    public Advertising getAdvertising(int ad) {
        return (Advertising)this.advertisings.get(ad);
    }

    public void invalidateCaches() {
        int size = 0;
        for (int i = 0; i < this.advertisings.size(); ++i) {
            Advertising inv = this.getAdvertising(i);
            size += inv.getArticleCount();
        }
        this.totalSize = size;
        this.adPerRow = null;
        this.articlesPerRow = null;
        this.reducedPricePerRow = null;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.totalSize;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    private void fillCache() {
        if (this.adPerRow != null && this.articlesPerRow != null) {
            return;
        }
        this.adPerRow = new Advertising[this.totalSize];
        this.articlesPerRow = new Article[this.totalSize];
        this.reducedPricePerRow = new double[this.totalSize];
        int currentRow = 0;
        int invoiceSize = this.advertisings.size();
        for (int i = 0; i < invoiceSize; ++i) {
            Advertising inv = (Advertising)this.advertisings.get(i);
            int articleCount = inv.getArticleCount();
            for (int ac = 0; ac < articleCount; ++ac) {
                this.adPerRow[currentRow] = inv;
                this.articlesPerRow[currentRow] = inv.getArticle(ac);
                this.reducedPricePerRow[currentRow] = inv.getArticleReducedPrice(ac);
                ++currentRow;
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.fillCache();
        Advertising inv = this.adPerRow[rowIndex];
        Article art = this.articlesPerRow[rowIndex];
        switch (columnIndex) {
            case 0: {
                return inv;
            }
            case 1: {
                return inv.getCustomer().getFirstName();
            }
            case 2: {
                return inv.getCustomer().getLastName();
            }
            case 3: {
                return inv.getCustomer().getStreet();
            }
            case 4: {
                return inv.getCustomer().getTown();
            }
            case 5: {
                return inv.getCustomer().getPostalCode();
            }
            case 6: {
                return inv.getCustomer().getCountry();
            }
            case 7: {
                return inv.getCustomer().getSalutation();
            }
            case 8: {
                return inv.getDate();
            }
            case 9: {
                return inv.getAdNumber();
            }
            case 10: {
                return art.getName();
            }
            case 11: {
                return art.getArticleNumber();
            }
            case 12: {
                return art.getArticleDetails();
            }
            case 13: {
                return new Float(art.getPrice());
            }
            case 14: {
                return new Double(this.reducedPricePerRow[rowIndex]);
            }
        }
        throw new IndexOutOfBoundsException("ColumnIndex");
    }
}

