/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Article;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Invoice;

public class InvoiceTableModel
extends AbstractTableModel {
    private static Class[] COLUMN_TYPES = new Class[]{Invoice.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Date.class, String.class, String.class, String.class, String.class, Float.class, Integer.class};
    private static String[] COLUMN_NAMES = new String[]{"invoice", "customer.firstName", "customer.lastName", "customer.street", "customer.town", "customer.postalCode", "customer.country", "customer.salutation", "invoice.date", "invoice.number", "article.name", "article.number", "article.details", "article.price", "article.count"};
    private transient Invoice[] invoicePerRow;
    private transient Article[] articlesPerRow;
    private transient int[] articleCountPerRow;
    private ArrayList invoices = new ArrayList();
    private int totalSize;

    public void addInvoice(Invoice invoice) {
        this.invoices.add(invoice);
        this.invalidateCaches();
        this.fireTableDataChanged();
    }

    public void removeInvoice(Invoice invoice) {
        this.invoices.remove(invoice);
        this.invalidateCaches();
        this.fireTableDataChanged();
    }

    public Invoice getInvoice(int invoice) {
        return (Invoice)this.invoices.get(invoice);
    }

    public void invalidateCaches() {
        int size = 0;
        for (int i = 0; i < this.invoices.size(); ++i) {
            Invoice inv = this.getInvoice(i);
            size += inv.getArticleCount();
        }
        this.totalSize = size;
        this.invoicePerRow = null;
        this.articlesPerRow = null;
        this.articleCountPerRow = null;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.totalSize;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    private void fillCache() {
        if (this.invoicePerRow != null && this.articlesPerRow != null) {
            return;
        }
        this.invoicePerRow = new Invoice[this.totalSize];
        this.articlesPerRow = new Article[this.totalSize];
        this.articleCountPerRow = new int[this.totalSize];
        int currentRow = 0;
        int invoiceSize = this.invoices.size();
        for (int i = 0; i < invoiceSize; ++i) {
            Invoice inv = (Invoice)this.invoices.get(i);
            int articleCount = inv.getArticleCount();
            for (int ac = 0; ac < articleCount; ++ac) {
                this.invoicePerRow[currentRow] = inv;
                this.articlesPerRow[currentRow] = inv.getArticle(ac);
                this.articleCountPerRow[currentRow] = inv.getArticleCount(ac);
                ++currentRow;
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.fillCache();
        Invoice inv = this.invoicePerRow[rowIndex];
        Article art = this.articlesPerRow[rowIndex];
        switch (columnIndex) {
            case 0: {
                return inv;
            }
            case 1: {
                return inv.getCustomer().getFirstName();
            }
            case 2: {
                return inv.getCustomer().getLastName();
            }
            case 3: {
                return inv.getCustomer().getStreet();
            }
            case 4: {
                return inv.getCustomer().getTown();
            }
            case 5: {
                return inv.getCustomer().getPostalCode();
            }
            case 6: {
                return inv.getCustomer().getCountry();
            }
            case 7: {
                return inv.getCustomer().getSalutation();
            }
            case 8: {
                return inv.getDate();
            }
            case 9: {
                return inv.getInvoiceNumber();
            }
            case 10: {
                return art.getName();
            }
            case 11: {
                return art.getArticleNumber();
            }
            case 12: {
                return art.getArticleDetails();
            }
            case 13: {
                return new Float(art.getPrice());
            }
            case 14: {
                return new Integer(this.articleCountPerRow[rowIndex]);
            }
        }
        throw new IndexOutOfBoundsException("ColumnIndex is invalid: " + columnIndex);
    }
}

