/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.combined;

import java.net.URL;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.JoiningTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.AdvertisingTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.InvoiceTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Advertising;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Article;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Customer;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Invoice;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CombinedAdvertisingDemoHandler
extends AbstractXmlDemoHandler {
    private TableModel data = this.initData();

    @Override
    public String getDemoName() {
        return "Combined Advertising Demo";
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"combined-invoice.html", CombinedAdvertisingDemoHandler.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"joined.xml", CombinedAdvertisingDemoHandler.class);
    }

    private TableModel initData() {
        Customer customer = new Customer("Will", "Snowman", "Mr.", "12 Federal Plaza", "12346", "AnOtherTown", "Lilliput");
        InvoiceTableModel iData = this.initInvoiceData(customer);
        AdvertisingTableModel aData = this.initAdData(customer);
        JoiningTableModel joiningTableModel = new JoiningTableModel();
        joiningTableModel.addTableModel("invoice", (TableModel)iData);
        joiningTableModel.addTableModel("ad", (TableModel)aData);
        return joiningTableModel;
    }

    private InvoiceTableModel initInvoiceData(Customer customer) {
        GregorianCalendar gc = new GregorianCalendar(2000, 10, 23);
        Invoice invoice = new Invoice(customer, gc.getTime(), "A-000-0123");
        Article mainboard = new Article("MB.001", "Ancient Mainboard", 199.5f);
        Article hardDisk = new Article("HD.201", "Very Slow Harddisk", 99.5f, "No warranty");
        Article memory = new Article("MEM.36", "Dusty RAM modules", 59.99f);
        Article operatingSystem = new Article("OS.36", "QDOS with C/PM compatibility module", 259.99f, "Serial #44638-444-123");
        invoice.addArticle(mainboard);
        invoice.addArticle(hardDisk);
        invoice.addArticle(memory);
        invoice.addArticle(memory);
        invoice.addArticle(operatingSystem);
        InvoiceTableModel invoiceData = new InvoiceTableModel();
        invoiceData.addInvoice(invoice);
        return invoiceData;
    }

    private AdvertisingTableModel initAdData(Customer customer) {
        GregorianCalendar gc = new GregorianCalendar(2000, 10, 23);
        Advertising ad = new Advertising(customer, gc.getTime(), "A-000-0123");
        Article mainboard = new Article("MB.A02", "ZUSE Z0001 Mainboard", 1299.5f);
        Article hardDisk = new Article("HD.201", "Sillicium Core HDD", 99.5f, "Even the babylonians used stone for long term document archiving, so why shouldn't you?");
        Article memory = new Article("MEM.30", "ferrit core memory", 119.99f);
        Article operatingSystem = new Article("OS.36", "Windows XP", 259.99f, "Experience the world of tomorrow by spreading trojans today.");
        ad.addArticle(mainboard, 999.99);
        ad.addArticle(hardDisk, 79.5);
        ad.addArticle(memory, 99.99f);
        ad.addArticle(operatingSystem, 199.99);
        AdvertisingTableModel adData = new AdvertisingTableModel();
        adData.addAdvertising(ad);
        return adData;
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }
}

