/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model;

import java.util.ArrayList;
import java.util.Date;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Article;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Customer;

public class Invoice {
    private ArrayList articles;
    private ArrayList articleCounts;
    private Customer customer;
    private Date date;
    private String invoiceNumber;

    public Invoice(Customer customer, Date date, String invoiceNumber) {
        this.customer = customer;
        this.date = date;
        this.invoiceNumber = invoiceNumber;
        this.articles = new ArrayList();
        this.articleCounts = new ArrayList();
    }

    public synchronized void addArticle(Article article) {
        int index = this.articles.indexOf(article);
        if (index == -1) {
            this.articles.add(article);
            this.articleCounts.add(new Integer(1));
        } else {
            Integer oldCount = (Integer)this.articleCounts.get(index);
            this.articleCounts.set(index, new Integer(oldCount + 1));
        }
    }

    public synchronized void removeArticle(Article article) {
        int index = this.articles.indexOf(article);
        if (index != -1) {
            Integer oldCount = (Integer)this.articleCounts.get(index);
            if (oldCount == 1) {
                this.articleCounts.remove(index);
                this.articles.remove(index);
            } else {
                this.articleCounts.set(index, new Integer(oldCount - 1));
            }
        }
    }

    public Article getArticle(int index) {
        return (Article)this.articles.get(index);
    }

    public int getArticleCount(int index) {
        Integer i = (Integer)this.articleCounts.get(index);
        return i;
    }

    public int getArticleCount() {
        return this.articles.size();
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Date getDate() {
        return this.date;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }
}

