/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.elementfactory.ContentFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.gui.pdf.PdfExportDialog;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class BandInBandStackingDemoHandler
extends AbstractDemoHandler {
    protected static final Log logger = LogFactory.getLog(BandInBandStackingDemoHandler.class);

    @Override
    public String getDemoName() {
        return "Band in Band Stacking Demo";
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"band-in-band.html", BandInBandStackingDemoHandler.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return new JPanel();
    }

    private Band createBand(String name, Color color, int x, int y, int width, int height) {
        Band band = new Band();
        band.setName("Band-" + name);
        band.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(width));
        band.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(height));
        band.getStyle().setStyleProperty(ElementStyleKeys.MAX_WIDTH, (Object)new Float(width));
        band.getStyle().setStyleProperty(ElementStyleKeys.MAX_HEIGHT, (Object)new Float(height));
        band.getStyle().setStyleProperty(ElementStyleKeys.POS_X, (Object)new Float(x));
        band.getStyle().setStyleProperty(ElementStyleKeys.POS_Y, (Object)new Float(y));
        band.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)color);
        return band;
    }

    @Override
    public MasterReport createReport() {
        Band levelA1 = this.createBand("A1", Color.magenta, 0, 0, 100, 100);
        levelA1.addElement((Element)this.createBand("A1-B1", Color.blue, 0, 50, 50, 50));
        levelA1.addElement((Element)this.createBand("A1-B2", Color.yellow, 50, 0, 150, 50));
        Band levelA2 = this.createBand("A2", Color.green, -50, 0, -50, -100);
        levelA2.addElement((Element)this.createBand("A2-B1", Color.red, 0, -50, -50, -50));
        levelA2.addElement((Element)this.createBand("A2-B2", Color.darkGray, -55, -5, -40, -40));
        ReportHeader header = new ReportHeader();
        header.setName("Report-Header");
        header.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(-100.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(100.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.MAX_WIDTH, (Object)new Float(32767.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.MAX_HEIGHT, (Object)new Float(100.0f));
        header.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)Color.ORANGE);
        header.addElement((Element)levelA1);
        header.addElement((Element)levelA2);
        ContentFieldElementFactory cfef = new ContentFieldElementFactory();
        cfef.setFieldname("CreateComponent");
        cfef.setMinimumSize((Dimension2D)new FloatDimension(400.0f, 400.0f));
        cfef.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        ReportFooter footer = new ReportFooter();
        footer.addElement(cfef.createElement());
        MasterReport report = new MasterReport();
        report.setReportHeader(header);
        report.setReportFooter(footer);
        report.setName("Band in Band stacking");
        report.addExpression((Expression)new ComplexComponentExpression("CreateComponent"));
        return report;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        BandInBandStackingDemoHandler demoHandler = new BandInBandStackingDemoHandler();
        SimpleDemoFrame frame = new SimpleDemoFrame(demoHandler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }

    private static class ComplexComponentExpression
    extends AbstractExpression {
        private transient Component pif;

        protected ComplexComponentExpression(String name) {
            this.setName(name);
            try {
                PdfExportDialog dlg = new PdfExportDialog();
                this.pif = dlg.getContentPane();
                this.pif.setVisible(true);
                dlg.setContentPane((Container)new JPanel());
            }
            catch (Exception e) {
                logger.error((Object)"PDFDialogInitialization failed");
            }
        }

        public Expression getInstance() {
            return new ComplexComponentExpression(this.getName());
        }

        public Object getValue() {
            return this.pif;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            PdfExportDialog dlg = new PdfExportDialog();
            this.pif = dlg.getContentPane();
            this.pif.setVisible(true);
        }
    }
}

