/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.DefaultReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;

public class DemoReportController
extends DefaultReportController {
    private static final Log logger = LogFactory.getLog(DemoReportController.class);
    public static final String MESSAGE_ONE_FIELDNAME = "Message1";
    public static final String MESSAGE_TWO_FIELDNAME = "Message2";
    private JTextArea messageOneField;
    private JTextArea messageTwoField;
    private Action updateAction;
    private PreviewPane previewPane;

    public DemoReportController() {
        this.setLayout(new GridBagLayout());
        JLabel messageOneLabel = new JLabel("One:");
        JLabel messageTwoLabel = new JLabel("Two:");
        this.messageOneField = new JTextArea();
        this.messageOneField.setWrapStyleWord(true);
        this.messageOneField.setRows(10);
        this.messageTwoField = new JTextArea();
        this.messageTwoField.setRows(10);
        this.messageTwoField.setWrapStyleWord(true);
        this.updateAction = new UpdateAction();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add(messageOneLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add(messageTwoLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add(new JScrollPane(this.messageOneField), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add(new JScrollPane(this.messageTwoField), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 13;
        this.add(new JButton(this.updateAction));
        this.setEnabled(false);
        this.messageOneField.setEnabled(false);
        this.messageTwoField.setEnabled(false);
        this.updateAction.setEnabled(false);
    }

    public PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.messageOneField.setEnabled(enabled);
        this.messageTwoField.setEnabled(enabled);
        this.updateAction.setEnabled(enabled);
    }

    public void initialize(PreviewPane pane) {
        super.initialize(pane);
        this.previewPane = pane;
        MasterReport report = this.previewPane.getReportJob();
        this.messageOneField.setText((String)report.getParameterValues().get(MESSAGE_ONE_FIELDNAME));
        this.messageTwoField.setText((String)report.getParameterValues().get(MESSAGE_TWO_FIELDNAME));
    }

    public void deinitialize(PreviewPane pane) {
        super.deinitialize(pane);
        this.previewPane = null;
    }

    private class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
            this.putValue("Name", "Update");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreviewPane base = DemoReportController.this.getPreviewPane();
            if (base == null) {
                return;
            }
            MasterReport report = base.getReportJob();
            report.getParameterValues().put(DemoReportController.MESSAGE_ONE_FIELDNAME, (Object)DemoReportController.this.messageOneField.getText());
            report.getParameterValues().put(DemoReportController.MESSAGE_TWO_FIELDNAME, (Object)DemoReportController.this.messageTwoField.getText());
            try {
                base.setReportJob(report);
            }
            catch (Exception ex) {
                logger.error((Object)"Unable to refresh the report.", (Throwable)ex);
            }
        }
    }
}

