/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.internalframe;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.functions.PaintComponentTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.ComponentDrawingDemoHandler;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.internalframe.DocumentInternalFrame;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class InternalFrameDemoFrame
extends AbstractDemoFrame {
    private static final Log logger = LogFactory.getLog(InternalFrameDemoFrame.class);
    private JDesktopPane desktop;

    public InternalFrameDemoFrame() {
        this.setTitle("InternalFrameDemo");
        this.setJMenuBar(this.createMenuBar());
        this.desktop = new JDesktopPane();
        this.setContentPane(this.desktop);
    }

    private static Rectangle getMaximumWindowBounds() {
        try {
            GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return localGraphicsEnvironment.getMaximumWindowBounds();
        }
        catch (Exception localGraphicsEnvironment) {
            Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
            return new Rectangle(0, 0, s.width, s.height);
        }
    }

    public void updateFrameSize(int inset) {
        Rectangle screenSize = InternalFrameDemoFrame.getMaximumWindowBounds();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Document");
        menu.setMnemonic(68);
        menuBar.add(menu);
        menu.add(new JMenuItem(new NewFrameAction()));
        menu.add(new JMenuItem(this.getPreviewAction()));
        menu.addSeparator();
        menu.add(new JMenuItem(this.getCloseAction()));
        JMenu helpmenu = new JMenu("Help");
        helpmenu.setMnemonic(72);
        helpmenu.add(new JMenuItem(this.getAboutAction()));
        return menuBar;
    }

    @Override
    protected void attemptPreview() {
        JInternalFrame frame = this.findSelectedFrame();
        if (frame == null) {
            return;
        }
        Rectangle bounds = frame.getBounds();
        Container parent = frame.getParent();
        boolean visible = frame.isVisible();
        int layer = frame.getLayer();
        this.previewReport(frame);
        if (parent != null && frame.getParent() != parent) {
            frame.getParent().remove(frame);
            parent.add(frame);
        }
        frame.setBounds(bounds);
        frame.setVisible(visible);
        frame.setLayer(new Integer(layer));
    }

    protected void previewReport(JInternalFrame frame) {
        try {
            URL in = ObjectUtilities.getResourceRelative((String)"component-drawing.xml", ComponentDrawingDemoHandler.class);
            if (in == null) {
                return;
            }
            ResourceManager mgr = new ResourceManager();
            Resource resource = mgr.createDirectly((Object)in, MasterReport.class);
            MasterReport report = (MasterReport)resource.getResource();
            report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.AllowOwnPeerForComponentDrawable", "true");
            PaintComponentTableModel tableModel = new PaintComponentTableModel();
            tableModel.addComponent(frame);
            report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)tableModel));
            PreviewDialog previewDialog = new PreviewDialog(report, (Frame)this, true);
            previewDialog.setToolbarFloatable(true);
            previewDialog.pack();
            LibSwingUtil.positionFrameRandomly((Window)previewDialog);
            previewDialog.setVisible(true);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to parse the report definition", (Throwable)e);
        }
    }

    private JInternalFrame findSelectedFrame() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            if (!frame.isSelected()) continue;
            return frame;
        }
        return null;
    }

    private class NewFrameAction
    extends AbstractAction {
        protected NewFrameAction() {
            this.putValue("MnemonicKey", new Integer(78));
            this.putValue("Name", "New");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 8));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentInternalFrame frame = new DocumentInternalFrame();
            frame.setSize(400, 300);
            frame.setVisible(true);
            InternalFrameDemoFrame.this.desktop.add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

