/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.multireport;

import java.awt.Window;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.JoiningTableModel;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ThreeMultiReportDemo
extends AbstractXmlDemoHandler {
    private final TableModel data = this.createJoinedTableModel();

    @Override
    public String getDemoName() {
        return "Multi-Report Demo";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"multireport.html", ThreeMultiReportDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"joined3-report.xml", ThreeMultiReportDemo.class);
    }

    private TableModel createFruitTableModel() {
        Object[] names = new String[]{"Id Number", "Cat", "Fruit"};
        Object[][] data = new Object[][]{{"I1", "A", "Apple"}, {"I2", "A", "Orange"}, {"I3", "B", "Water melon"}, {"I4", "B", "Strawberry"}};
        return new DefaultTableModel(data, names);
    }

    private TableModel createAnimalTableModel() {
        Object[] names = new String[]{"Id Number", "Cat", "Animal"};
        Object[][] data = new Object[][]{{"A1", "A", "Ape"}, {"A2", "A", "Dog"}, {"A3", "B", "Frog"}, {"A4", "B", "Snake"}, {"A5", "B", "Aligator"}};
        return new DefaultTableModel(data, names);
    }

    private TableModel createColorTableModel() {
        Object[] names = new String[]{"Number", "Group", "Color"};
        Object[][] data = new Object[][]{{new Integer(1), "X", "Red"}, {new Integer(2), "X", "Green"}, {new Integer(3), "Y", "Yellow"}, {new Integer(4), "Y", "Blue"}, {new Integer(5), "Z", "Orange"}, {new Integer(6), "Z", "White"}};
        return new DefaultTableModel(data, names);
    }

    private TableModel createJoinedTableModel() {
        JoiningTableModel jtm = new JoiningTableModel();
        jtm.addTableModel("Color", this.createColorTableModel());
        jtm.addTableModel("Fruit", this.createFruitTableModel());
        jtm.addTableModel("Animal", this.createAnimalTableModel());
        return jtm;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        ThreeMultiReportDemo demoHandler = new ThreeMultiReportDemo();
        SimpleDemoFrame frame = new SimpleDemoFrame(demoHandler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

