/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.nogui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PrintReportProcessor;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.PngEncoder;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;

public class StraightToPNG {
    private static final Log logger = LogFactory.getLog(StraightToPNG.class);

    public StraightToPNG(String filename) throws ParseException {
        URL in = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/opensource.xml", StraightToPNG.class);
        MasterReport report = this.parseReport(in);
        OpenSourceProjects data = new OpenSourceProjects();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)data));
        long startTime = System.currentTimeMillis();
        this.savePNG(report, filename);
    }

    private MasterReport parseReport(URL templateURL) throws ParseException {
        try {
            ResourceManager mgr = new ResourceManager();
            Resource resource = mgr.createDirectly((Object)templateURL, MasterReport.class);
            MasterReport report = (MasterReport)resource.getResource();
            URL imageURL = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/gorilla.jpg", StraightToPNG.class);
            Image image = Toolkit.getDefaultToolkit().createImage(imageURL);
            WaitingImageObserver obs = new WaitingImageObserver(image);
            obs.waitImageLoaded();
            report.getParameterValues().put("logo", (Object)image);
            return report;
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse the report", e);
        }
    }

    public boolean savePNG(MasterReport report, String fileName) {
        try {
            PrintReportProcessor prc = new PrintReportProcessor(report);
            int numberOfPages = prc.getNumberOfPages();
            for (int i = 0; i < numberOfPages; ++i) {
                String fileNameFormated = MessageFormat.format(fileName, new Integer(i));
                BufferedImage image = this.createImage(report.getPageDefinition());
                Rectangle rect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
                Graphics2D g2 = image.createGraphics();
                g2.setPaint(Color.white);
                g2.fill(rect);
                PageDrawable pageDrawable = prc.getPageDrawable(i);
                pageDrawable.draw(g2, (Rectangle2D)rect);
                g2.dispose();
                PngEncoder encoder = new PngEncoder((Image)image, true, 0, 9);
                byte[] data = encoder.pngEncode();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileNameFormated));
                out.write(data);
                out.close();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Writing PDF failed.");
            e.printStackTrace();
            return false;
        }
    }

    private BufferedImage createImage(PageDefinition pd) {
        PageFormat pf = pd.getPageFormat(0);
        double width = pf.getWidth();
        double height = pf.getHeight();
        return new BufferedImage((int)width, (int)height, 13);
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        try {
            new StraightToPNG(System.getProperty("user.home") + "/OpenSource-Demo-{0}.png");
            System.exit(0);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to run demo", (Throwable)e);
            System.exit(1);
        }
    }
}

