/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.nogui;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;

public class StraightToPlainText {
    private static final Log logger = LogFactory.getLog(StraightToPlainText.class);

    public StraightToPlainText(String filename) throws ParseException {
        URL in = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/opensource.xml", StraightToPlainText.class);
        MasterReport report = this.parseReport(in);
        OpenSourceProjects data = new OpenSourceProjects();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)data));
        this.savePlainText(report, filename);
    }

    private MasterReport parseReport(URL templateURL) throws ParseException {
        try {
            ResourceManager mgr = new ResourceManager();
            Resource resource = mgr.createDirectly((Object)templateURL, MasterReport.class);
            MasterReport report = (MasterReport)resource.getResource();
            report.getParameterValues().put("logo", null);
            return report;
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse the report", e);
        }
    }

    public boolean savePlainText(MasterReport report, String fileName) {
        try {
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(fileName));
            TextFilePrinterDriver pc = new TextFilePrinterDriver((OutputStream)fout, 15.0f, 10.0f);
            PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor((PrinterDriver)pc, report.getConfiguration());
            PageableReportProcessor proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
            proc.processReport();
            proc.close();
            fout.close();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Writing PlainText failed.", (Throwable)e);
            return false;
        }
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        try {
            new StraightToPlainText(System.getProperty("user.home") + "/OpenSource-Demo.txt");
            System.exit(0);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to run demo", (Throwable)e);
            System.exit(1);
        }
    }
}

