/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.NumberFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.PageFunction;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.ExcelReportUtil;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class OpenSourceAPIDemoHandler
extends AbstractDemoHandler {
    private TableModel data = new OpenSourceProjects();

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"opensource-api.html", OpenSourceAPIDemoHandler.class);
    }

    @Override
    public String getDemoName() {
        return "Open Source Demo (API)";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = OpenSourceAPIDemoHandler.createStaticReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    public static MasterReport createStaticReport() {
        MasterReport result = new MasterReport();
        PageFunction f1 = new PageFunction("page_number");
        result.addExpression((Expression)f1);
        ItemBand itemBand = result.getItemBand();
        OpenSourceAPIDemoHandler.configureItemBand(itemBand);
        PageFooter pageFooter = result.getPageFooter();
        OpenSourceAPIDemoHandler.configurePageFooter(pageFooter);
        return result;
    }

    private static void configureItemBand(ItemBand band) {
        ElementStyleSheet ess = band.getStyle();
        ess.setStyleProperty(TextStyleKeys.FONT, (Object)"SansSerif");
        ess.setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(9));
        TextFieldElementFactory factory = new TextFieldElementFactory();
        factory.setName("Name_Field");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 2.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(140.0f, 10.0f));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.BOTTOM);
        factory.setFontName("SansSerif");
        factory.setFontSize(new Integer(10));
        factory.setBold(Boolean.TRUE);
        factory.setNullString("No Name");
        factory.setFieldname("Name");
        band.addElement(factory.createElement());
        factory = new TextFieldElementFactory();
        factory.setName("URL_Field");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(140.0f, 2.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 10.0f));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.RIGHT);
        factory.setVerticalAlignment(ElementAlignment.BOTTOM);
        factory.setFontName("Monospaced");
        factory.setFontSize(new Integer(8));
        factory.setNullString("No URL");
        factory.setFieldname("URL");
        band.addElement(factory.createElement());
        factory = new TextFieldElementFactory();
        factory.setName("Description_Field");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 20.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 10.0f));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setVerticalAlignment(ElementAlignment.TOP);
        factory.setNullString("No description available");
        factory.setFieldname("Description");
        factory.setDynamicHeight(Boolean.TRUE);
        band.addElement(factory.createElement());
    }

    private static void configurePageFooter(PageFooter footer) {
        footer.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(20.0f));
        ElementStyleSheet ess = footer.getStyle();
        ess.setStyleProperty(TextStyleKeys.FONT, (Object)"SansSerif");
        ess.setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(9));
        NumberFieldElementFactory factory = new NumberFieldElementFactory();
        factory.setName("PageNumber_Field");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new Dimension(-100, -100));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.RIGHT);
        factory.setNullString("-");
        factory.setFormatString("Page 0");
        factory.setFieldname("page_number");
        factory.setFontName("SansSerif");
        factory.setFontSize(new Integer(10));
        factory.setBold(Boolean.TRUE);
        footer.addElement(factory.createElement());
    }

    public static void main(String[] args) throws ReportDefinitionException, ReportProcessingException, IOException {
        ClassicEngineBoot.getInstance().start();
        OpenSourceAPIDemoHandler handler = new OpenSourceAPIDemoHandler();
        MasterReport report = handler.createReport();
        ExcelReportUtil.createXLS((MasterReport)report, (String)"/tmp/out.xls");
    }
}

