/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.surveyscale;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.elementfactory.ContentFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.HorizontalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.LabelElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.MessageFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.NumberFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.RectangleElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ItemCountFunction;
import org.pentaho.reporting.engine.classic.core.function.PageOfPagesFunction;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScale;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScaleExpression;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.engine.classic.core.util.PageSize;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.surveyscale.SurveyScaleDemoTableModel;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class SurveyScaleAPIDemoHandler
extends AbstractDemoHandler {
    private static final float PAGE_MARGIN_TOP = 36.0f;
    private static final float PAGE_MARGIN_BOTTOM = 36.0f;
    private static final float PAGE_MARGIN_LEFT = 36.0f;
    private static final float PAGE_MARGIN_RIGHT = 36.0f;
    private static final float X0 = 0.0f;
    private static final float LEFT_GAP = 15.0f;
    private static final float RIGHT_GAP = 15.0f;
    private static final float X1 = 15.0f;
    private static final float C1_WIDTH = 220.0f;
    private static final float X2 = 235.0f;
    private static final float C2_WIDTH = 176.0f;
    private static final float X3 = 411.0f;
    private static final float PRINT_WIDTH = (float)PageSize.A4.getWidth();
    private static final float C3_WIDTH = (PRINT_WIDTH - 15.0f - 220.0f - 176.0f - 15.0f) / 2.0f;
    private static final float X4 = 411.0f + C3_WIDTH;
    private static final float C4_WIDTH = C3_WIDTH;
    private static final float COLUMN_HEADER_BOX_HEIGHT = 20.0f;
    private static final float BOX_TOP = 100.0f;
    private TableModel data = new SurveyScaleDemoTableModel();

    @Override
    public String getDemoName() {
        return "Survey Scale Demo Report (API)";
    }

    @Override
    public MasterReport createReport() {
        MasterReport report = new MasterReport();
        report.setName("Survey Scale Demo Report");
        PageFormatFactory pff = PageFormatFactory.getInstance();
        Paper paper = pff.createPaper(PageSize.A4);
        pff.setBorders(paper, 36.0, 36.0, 36.0, 36.0);
        PageFormat format = pff.createPageFormat(paper, 1);
        report.setPageDefinition((PageDefinition)new SimplePageDefinition(format));
        this.setupWatermark(report);
        this.setupPageHeader(report);
        this.setupGroup(report);
        this.setupItemBand(report);
        this.setupPageFooter(report);
        report.getParameterValues().put("RESPONDENT_NAME", (Object)"Dave");
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    private void setupPageFooter(MasterReport report) {
        PageFooter pageFooter = report.getPageFooter();
        pageFooter.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(65.0f));
        pageFooter.addElement(HorizontalLineElementFactory.createHorizontalLine((float)0.0f, (Color)Color.BLACK, null));
        PageOfPagesFunction pageNofM = new PageOfPagesFunction();
        pageNofM.setName("PAGE_N_OF_M");
        pageNofM.setFormat("Page {0} of {1}");
        report.addExpression((Expression)pageNofM);
        TextFieldElementFactory tff = new TextFieldElementFactory();
        tff.setName("PageIndicator");
        tff.setAbsolutePosition((Point2D)new Point2D.Double((double)(X4 + C4_WIDTH) - 60.0, 50.0));
        tff.setMinimumSize((Dimension2D)new FloatDimension(60.0f, 15.0f));
        tff.setFontName("Serif");
        tff.setItalic(Boolean.TRUE);
        tff.setFontSize(new Integer(8));
        tff.setHorizontalAlignment(ElementAlignment.RIGHT);
        tff.setFieldname("PAGE_N_OF_M");
        pageFooter.addElement(tff.createElement());
        LabelElementFactory labelFactory = new LabelElementFactory();
        labelFactory.setText("Copyright \u00a9 2004 Object Refinery Limited. All Rights Reserved.");
        labelFactory.setFontName("Serif");
        labelFactory.setItalic(Boolean.TRUE);
        labelFactory.setFontSize(new Integer(8));
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Double(15.0, 50.0));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(444.0f, 15.0f));
        labelFactory.setHorizontalAlignment(ElementAlignment.LEFT);
        pageFooter.addElement(labelFactory.createElement());
    }

    private void setupItemBand(MasterReport report) {
        ItemBand band = report.getItemBand();
        band.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(20.0f));
        ItemCountFunction icf = new ItemCountFunction();
        icf.setName("ITEM_COUNT");
        report.addExpression((Expression)icf);
        TextFieldElementFactory factory2 = new TextFieldElementFactory();
        factory2.setFontName("Serif");
        factory2.setFontSize(new Integer(11));
        factory2.setBold(Boolean.FALSE);
        NumberFieldElementFactory nf = new NumberFieldElementFactory();
        nf.setName("ItemNumberTextField");
        nf.setAbsolutePosition((Point2D)new Point2D.Double(15.0, 7.0));
        nf.setMinimumSize((Dimension2D)new FloatDimension(25.0f, 16.0f));
        nf.setVerticalAlignment(ElementAlignment.TOP);
        nf.setFieldname("ITEM_COUNT");
        nf.setFormatString("#0'.'");
        band.addElement(nf.createElement());
        factory2.setName("ItemField");
        factory2.setAbsolutePosition((Point2D)new Point2D.Double(40.0, 7.0));
        factory2.setMinimumSize((Dimension2D)new FloatDimension(195.0f, 16.0f));
        factory2.setDynamicHeight(Boolean.TRUE);
        factory2.setTrimTextContent(Boolean.TRUE);
        factory2.setFieldname("Item");
        band.addElement(factory2.createElement());
        SurveyScaleExpression iaf1 = new SurveyScaleExpression(1, 5);
        iaf1.setName("Survey Response");
        iaf1.setField(0, "Your Response");
        iaf1.setField(1, "Average Response");
        report.addExpression((Expression)iaf1);
        ContentFieldElementFactory f = new ContentFieldElementFactory();
        f.setFieldname("Survey Response");
        f.setMinimumSize((Dimension2D)new FloatDimension(176.0f, 15.0f));
        f.setAbsolutePosition((Point2D)new Point2D.Double(235.0, 6.0));
        band.addElement(f.createElement());
        NumberFieldElementFactory nfef = new NumberFieldElementFactory();
        nfef.setFontName("Serif");
        nfef.setFontSize(new Integer(11));
        nfef.setName("F1");
        nfef.setAbsolutePosition((Point2D)new Point2D.Double(411.0, 7.0));
        nfef.setMinimumSize((Dimension2D)new FloatDimension(C3_WIDTH, 16.0f));
        nfef.setFieldname("Your Response");
        nfef.setFormatString("0.00");
        nfef.setHorizontalAlignment(ElementAlignment.CENTER);
        band.addElement(nfef.createElement());
        nfef.setName("F2");
        nfef.setAbsolutePosition((Point2D)new Point2D.Double(X4, 7.0));
        nfef.setFieldname("Average Response");
        band.addElement(nfef.createElement());
    }

    private void setupGroup(MasterReport report) {
        RelationalGroup group = new RelationalGroup();
        group.setName("Category Group");
        group.addField("Category");
        GroupHeader gh = group.getHeader();
        gh.setRepeat(true);
        gh.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(26.0f));
        TextFieldElementFactory factory1 = new TextFieldElementFactory();
        factory1.setName("CategoryTextField");
        factory1.setAbsolutePosition((Point2D)new Point2D.Double(15.0, 10.0));
        factory1.setMinimumSize((Dimension2D)new FloatDimension(396.0f + C3_WIDTH, 16.0f));
        factory1.setVerticalAlignment(ElementAlignment.TOP);
        factory1.setFieldname("Category");
        factory1.setFontName("SansSerif");
        factory1.setFontSize(new Integer(12));
        factory1.setBold(Boolean.TRUE);
        factory1.setDynamicHeight(Boolean.TRUE);
        factory1.setTrimTextContent(Boolean.TRUE);
        gh.addElement(factory1.createElement());
        factory1.setFieldname("Category Description");
        factory1.setBold(Boolean.FALSE);
        factory1.setAbsolutePosition((Point2D)new Point2D.Double(15.0, 26.0));
        factory1.setFontName("Serif");
        factory1.setFontSize(new Integer(11));
        gh.addElement(factory1.createElement());
        report.addGroup(group);
    }

    private void setupPageHeader(MasterReport report) {
        PageHeader pageHeader = report.getPageHeader();
        pageHeader.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(20.0f));
        LabelElementFactory labelFactory = new LabelElementFactory();
        labelFactory.setText("Free / Open Source Software Survey");
        labelFactory.setFontName("SansSerif");
        labelFactory.setFontSize(new Integer(18));
        labelFactory.setBold(Boolean.TRUE);
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Double(15.0, 10.0));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(396.0f + C3_WIDTH + C4_WIDTH, 28.0f));
        labelFactory.setHorizontalAlignment(ElementAlignment.CENTER);
        pageHeader.addElement(labelFactory.createElement());
        MessageFieldElementFactory tfef = new MessageFieldElementFactory();
        tfef.setFormatString("Respondent: $(RESPONDENT_NAME)");
        tfef.setFontName("SansSerif");
        tfef.setFontSize(new Integer(12));
        tfef.setBold(Boolean.TRUE);
        tfef.setAbsolutePosition((Point2D)new Point2D.Double(0.0, 38.0));
        tfef.setMinimumSize((Dimension2D)new FloatDimension(PRINT_WIDTH, 14.0f));
        tfef.setHorizontalAlignment(ElementAlignment.CENTER);
        pageHeader.addElement(tfef.createElement());
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Double(15.0, 58.0));
        labelFactory.setText("Please note that the questions AND responses presented below were INVENTED for the the purpose of this demo report.  They are NOT real.");
        labelFactory.setFontName("Serif");
        labelFactory.setFontSize(new Integer(11));
        labelFactory.setBold(Boolean.FALSE);
        labelFactory.setItalic(Boolean.TRUE);
        pageHeader.addElement(labelFactory.createElement());
        labelFactory.setFontName("SansSerif");
        labelFactory.setFontSize(new Integer(7));
        labelFactory.setItalic(Boolean.FALSE);
        labelFactory.setBold(Boolean.FALSE);
        labelFactory.setVerticalAlignment(ElementAlignment.BOTTOM);
        float delta = 35.2f;
        labelFactory.setText("Not Important");
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Double(235.0, 70.0));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(35.2f, 30.0f));
        pageHeader.addElement(labelFactory.createElement());
        labelFactory.setText("Very Important");
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Double(375.8f, 70.0));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(35.2f, 30.0f));
        pageHeader.addElement(labelFactory.createElement());
        SurveyScaleAPIDemoHandler.addBoxedLabelToBand((Band)pageHeader, null, 15.0f, 100.0f, 220.0f, 20.0f, "SansSerif", 10, true, Color.black, new Color(220, 255, 220));
        SurveyScaleAPIDemoHandler.addBoxedLabelToBand((Band)pageHeader, null, 235.0f, 100.0f, 176.0f, 20.0f, "SansSerif", 10, true, Color.black, new Color(220, 255, 220));
        SurveyScale scaleHeader = new SurveyScale(1, 5, null);
        scaleHeader.setDrawScaleValues(true);
        scaleHeader.setDrawTickMarks(false);
        scaleHeader.setScaleValueFont(new Font("SansSerif", 0, 9));
        report.getParameterValues().put("SCALE_HEADER", (Object)scaleHeader);
        ContentFieldElementFactory dfef = new ContentFieldElementFactory();
        dfef.setName("ScaleHeaderElement");
        dfef.setAbsolutePosition((Point2D)new Point2D.Double(235.0, 100.0));
        dfef.setFieldname("SCALE_HEADER");
        dfef.setMinimumSize((Dimension2D)new FloatDimension(176.0f, 20.0f));
        pageHeader.addElement(dfef.createElement());
        SurveyScaleAPIDemoHandler.addBoxedLabelToBand((Band)pageHeader, "Your Response", 411.0f, 100.0f, C3_WIDTH, 20.0f, "SansSerif", 8, false, Color.black, new Color(220, 255, 220));
        SurveyScaleAPIDemoHandler.addBoxedLabelToBand((Band)pageHeader, "Average Response", 411.0f + C3_WIDTH, 100.0f, C3_WIDTH, 20.0f, "SansSerif", 8, false, Color.black, new Color(220, 255, 220));
    }

    private void setupWatermark(MasterReport report) {
        Watermark watermarkBand = report.getWatermark();
        RectangleElementFactory sef = new RectangleElementFactory();
        sef.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, -100.0f));
        sef.setColor(Color.black);
        sef.setStroke((Stroke)new BasicStroke(1.0f));
        sef.setShouldDraw(Boolean.TRUE);
        sef.setScale(Boolean.TRUE);
        sef.setKeepAspectRatio(Boolean.FALSE);
        watermarkBand.addElement(sef.createElement());
    }

    private static void addBoxedLabelToBand(Band band, String label, float x, float y, float w, float h, String fontName, int fontSize, boolean bold, Color outlineColor, Color backgroundColor) {
        LabelElementFactory f2 = new LabelElementFactory();
        f2.setAbsolutePosition((Point2D)new Point2D.Double(x, y));
        f2.setMinimumSize((Dimension2D)new FloatDimension(w, h));
        f2.setText(label);
        f2.setFontName(fontName);
        f2.setFontSize(new Integer(fontSize));
        f2.setBold(bold ? Boolean.TRUE : Boolean.FALSE);
        f2.setHorizontalAlignment(ElementAlignment.CENTER);
        f2.setVerticalAlignment(ElementAlignment.MIDDLE);
        f2.setBackgroundColor(backgroundColor);
        f2.setBorderColor(outlineColor);
        f2.setBorderStyle(BorderStyle.SOLID);
        band.addElement(f2.createElement());
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"survey-api.html", SurveyScaleAPIDemoHandler.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }
}

