/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.elements.sparklines;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.HorizontalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.engine.classic.extensions.modules.sparklines.elementfactory.BarSparklineElementFactory;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class SparklineAPIDemo
extends AbstractDemoHandler {
    private DefaultTableModel data;
    private final Random random = new Random();

    public SparklineAPIDemo() {
        this.data = this.createData();
    }

    private DefaultTableModel createData() {
        Object[] columnNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        DefaultTableModel data = new DefaultTableModel(columnNames, 10);
        for (int r = 0; r < 10; ++r) {
            for (int i = 0; i < 12 && r < 10; ++i) {
                int neg = -this.random.nextInt(2);
                if (neg == 0) {
                    neg = 1;
                }
                Integer value = new Integer(neg * this.random.nextInt(30));
                data.setValueAt(value, r, i);
            }
        }
        return data;
    }

    @Override
    public String getDemoName() {
        return "Sparkline bar-graph demo (API)";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = new MasterReport();
        report.setName("Sparkline Demo");
        DefaultParameterDefinition paramDef = new DefaultParameterDefinition();
        PlainParameter plainParameter = new PlainParameter("sparkline-data", Number[].class);
        plainParameter.setDefaultValue((Object)new Number[]{new Integer(10), new Integer(5), new Integer(6), new Integer(3), new Integer(1), new Integer(2), new Integer(7), new Integer(9)});
        paramDef.addParameterDefinition((ParameterDefinitionEntry)plainParameter);
        report.setParameterDefinition((ReportParameterDefinition)paramDef);
        BarSparklineElementFactory elementFactory = new BarSparklineElementFactory();
        elementFactory.setFieldname("sparkline-data");
        elementFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        elementFactory.setMinimumSize((Dimension2D)new Dimension(100, 10));
        elementFactory.setColor(Color.black);
        elementFactory.setHighColor(Color.red);
        elementFactory.setLastColor(Color.blue);
        elementFactory.setBackgroundColor(Color.orange);
        ReportFooter footer = report.getReportFooter();
        footer.addElement(elementFactory.createElement());
        BarSparklineElementFactory itemsSparkFactory = new BarSparklineElementFactory();
        itemsSparkFactory.setFormula("={[January]|[February]|[March]|[April]|[May]|[June]|[July]|[August]|[September]|[October]|[November]|[December]}");
        itemsSparkFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        itemsSparkFactory.setMinimumSize((Dimension2D)new Dimension(100, 10));
        itemsSparkFactory.setHighColor(Color.green);
        itemsSparkFactory.setLastColor(Color.blue);
        ItemBand itemBand = report.getItemBand();
        itemBand.addElement(itemsSparkFactory.createElement());
        itemBand.addElement(HorizontalLineElementFactory.createHorizontalLine((float)15.0f, null, (Stroke)new BasicStroke(5.0f)));
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)this.data));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return null;
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    public static void main(String[] args) throws Exception {
        ClassicEngineBoot.getInstance().start();
        SparklineAPIDemo demoHandler = new SparklineAPIDemo();
        SimpleDemoFrame frame = new SimpleDemoFrame(demoHandler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

