/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.elements.sparklines;

import java.net.URL;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SparklineXMLDemo
extends AbstractXmlDemoHandler {
    private DefaultTableModel data;
    private final Random random = new Random();

    public SparklineXMLDemo() {
        this.data = this.createData();
    }

    private DefaultTableModel createData() {
        Object[] columnNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        DefaultTableModel data = new DefaultTableModel(columnNames, 10);
        for (int r = 0; r < 10; ++r) {
            for (int i = 0; i < 12 && r < 10; ++i) {
                Integer value = new Integer(this.random.nextInt(30));
                data.setValueAt(value, r, i);
            }
        }
        return data;
    }

    @Override
    public String getDemoName() {
        return "Sparkline bar-graph demo (Simple-XML)";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)this.data));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"sparkline-simple.html", SparklineXMLDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"sparkline-simple.xml", SparklineXMLDemo.class);
    }
}

