/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.features.autotable;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.wizard.RelationalAutoGeneratorPreProcessor;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.repository.ContentIOException;

public class AutoTableAPIDemo
extends AbstractDemoHandler {
    @Override
    public String getDemoName() {
        return "Automatic-Report Demo";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        DriverConnectionProvider drc = new DriverConnectionProvider();
        drc.setDriver("org.hsqldb.jdbcDriver");
        drc.setUrl("jdbc:hsqldb:./sql/sampledata");
        drc.setProperty("user", "sa");
        drc.setProperty("password", "");
        SQLReportDataFactory sqlDataFactory = new SQLReportDataFactory((ConnectionProvider)drc);
        sqlDataFactory.setQuery("default", "      SELECT\n           QUADRANT_ACTUALS.REGION,\n           QUADRANT_ACTUALS.DEPARTMENT,\n           QUADRANT_ACTUALS.POSITIONTITLE,\n           QUADRANT_ACTUALS.ACTUAL,\n           QUADRANT_ACTUALS.BUDGET,\n           QUADRANT_ACTUALS.VARIANCE\n      FROM\n           QUADRANT_ACTUALS\n      ORDER BY\n          REGION, DEPARTMENT, POSITIONTITLE", null, null);
        MasterReport report = new MasterReport();
        report.setDataFactory((DataFactory)sqlDataFactory);
        report.setQuery("default");
        report.addPreProcessor((ReportPreProcessor)new RelationalAutoGeneratorPreProcessor());
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"auto-table.html", AutoTableAPIDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return new JPanel();
    }

    public void writeBundle(String path) throws IOException, ContentIOException, BundleWriterException, ReportDefinitionException {
        BundleWriter.writeReportToZipFile((MasterReport)this.createReport(), (File)new File(path));
    }

    public static void main(String[] args) throws ReportProcessingException, IOException, ReportDefinitionException, ContentIOException, BundleWriterException {
        ClassicEngineBoot.getInstance().start();
        AutoTableAPIDemo handler = new AutoTableAPIDemo();
        handler.writeBundle("/tmp/auto-table.prc");
        SimpleDemoFrame frame = new SimpleDemoFrame(handler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

