/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.features.loading;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class FileLoadingDemo
extends AbstractDemoHandler {
    private JPanel panel;
    private JTextField textField = new JTextField();

    public FileLoadingDemo() {
        this.textField.setColumns(40);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        JPanel selectCarrier = new JPanel();
        selectCarrier.add((Component)this.textField, "Center");
        selectCarrier.add(new JButton(new BrowseAction()));
        this.panel.add((Component)selectCarrier, "North");
    }

    @Override
    public String getDemoName() {
        return "File Loading Demo";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        File file = new File(this.textField.getText());
        try {
            ResourceManager manager = new ResourceManager();
            Resource res = manager.createDirectly((Object)file, MasterReport.class);
            return (MasterReport)res.getResource();
        }
        catch (Exception e) {
            throw new ReportDefinitionException("Parsing failed", e);
        }
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"file-loading.html", FileLoadingDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.panel;
    }

    private class BrowseAction
    extends AbstractAction {
        private JFileChooser fileChooser;

        private BrowseAction() {
            this.putValue("Name", "Browse");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fileChooser == null) {
                FilesystemFilter filter = new FilesystemFilter(new String[]{".xml", ".report", ".prpt", ".prpti"}, "Report Definitions (*.xml, *.report, *.prpt)", true);
                this.fileChooser = new JFileChooser();
                this.fileChooser.setAcceptAllFileFilterUsed(true);
                this.fileChooser.addChoosableFileFilter((FileFilter)filter);
                this.fileChooser.setMultiSelectionEnabled(false);
            }
            if (this.fileChooser.showOpenDialog(FileLoadingDemo.this.panel) != 0) {
                return;
            }
            File selectedFile = this.fileChooser.getSelectedFile();
            if (selectedFile != null) {
                FileLoadingDemo.this.textField.setText(selectedFile.getAbsolutePath());
            }
        }
    }
}

