/*
* This program is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License, version 2.1 as published by the Free Software
* Foundation.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* program; if not, you can obtain a copy at http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html
* or from the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* Copyright (c) 2001 - 2013 Object Refinery Ltd, Hitachi Vantara and Contributors..  All rights reserved.
*/

package org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewApplet;

/**
 * This demo application replicates the report generated by OpenSourceXMLDemoHandler.java, but creates the report in
 * code rather than using an XML report template. The whole report is displayed in an applet.
 * <p/>
 * To use or adopt that applet to your own needs, just change the getReport() method and your applet should work
 * perfectly ...
 *
 * @author Thomas Morgner
 */
public class OpenSourceDemoApplet extends PreviewApplet
{
  /**
   * The report (created in code).
   */
  private MasterReport report;

  /**
   * Constructs the demo applet.
   */
  public OpenSourceDemoApplet()
  {
    // initialize JFreeReport
    ClassicEngineBoot.getInstance().start();
  }

  public void init()
  {
    super.init();
    setReportJob(createReport());
  }

  /**
   * Creates a report definition in code.
   * <p/>
   * It is more base to read the definition from an XML report template file, but sometimes you might need to create a
   * report dynamically.
   *
   * @return a report.
   */
  public MasterReport createReport()
  {

    if (this.report != null)
    {
      return this.report;
    }

    // uses the report from the OpenSourceXMLDemoHandler 2 ...
    this.report = OpenSourceAPIDemoHandler.createStaticReport();
    report.setDataFactory(new TableDataFactory("default", new OpenSourceProjects()));
    return report;
  }

}
