/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.cards;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.AccountCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.Card;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.CardType;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.FreeCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.PrepaidCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.UserCard;

public class CardTableModel
extends AbstractTableModel {
    private final ArrayList cards = new ArrayList();
    private static final int POS_TYPE = 0;
    private static final int POS_NAME = 1;
    private static final int POS_FIRSTNAME = 2;
    private static final int POS_CARDNR = 3;
    private static final int POS_LOGIN = 4;
    private static final int POS_PASSWORD = 5;
    private static final int POS_EXPIRES = 6;
    private static final String[] COL_NAMES = new String[]{"type", "name", "firstName", "cardNr", "login", "password", "expires"};

    public void addCard(Card c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.cards.add(c);
    }

    @Override
    public int getRowCount() {
        return this.cards.size();
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return CardType.class;
        }
        if (columnIndex == 6) {
            return Date.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return COL_NAMES[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Card c = (Card)this.cards.get(rowIndex);
        if (columnIndex == 0) {
            return c.getType();
        }
        if (c.getType() == CardType.ACCOUNT) {
            AccountCard ac = (AccountCard)c;
            if (columnIndex == 1) {
                return ac.getLastName();
            }
            if (columnIndex == 2) {
                return ac.getFirstName();
            }
            if (columnIndex == 4) {
                return ac.getLogin();
            }
            if (columnIndex == 5) {
                return ac.getPassword();
            }
        } else if (c.getType() == CardType.ADMIN || c.getType() == CardType.USER) {
            UserCard ac = (UserCard)c;
            if (columnIndex == 1) {
                return ac.getLastName();
            }
            if (columnIndex == 2) {
                return ac.getFirstName();
            }
            if (columnIndex == 4) {
                return ac.getLogin();
            }
            if (columnIndex == 5) {
                return ac.getPassword();
            }
            if (columnIndex == 3) {
                return ac.getCardNr();
            }
            if (columnIndex == 6) {
                return ac.getExpires();
            }
        } else if (c.getType() == CardType.FREE) {
            FreeCard ac = (FreeCard)c;
            if (columnIndex == 3) {
                return ac.getCardNr();
            }
            if (columnIndex == 6) {
                return ac.getExpires();
            }
        } else if (c.getType() == CardType.PREPAID) {
            PrepaidCard ac = (PrepaidCard)c;
            if (columnIndex == 1) {
                return ac.getLastName();
            }
            if (columnIndex == 2) {
                return ac.getFirstName();
            }
            if (columnIndex == 3) {
                return ac.getCardNr();
            }
        }
        return null;
    }
}

