/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.cards;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.CardType;

public class SelectCardFunction
extends AbstractFunction
implements Serializable {
    private String baseCard;
    private String field;
    private String account;
    private String admin;
    private String user;
    private String prepaid;
    private String free;
    private String empty;

    private void selectBand(Band band) {
        CardType type = (CardType)this.getDataRow().get(this.getField());
        if (type == null) {
            type = CardType.EMPTY;
        }
        String bandName = this.getBandForCardType(type);
        if (type == CardType.EMPTY) {
            band.setVisible(false);
        } else {
            band.setVisible(true);
            Element[] elements = band.getElementArray();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof Band)) continue;
                Element e = elements[i];
                e.setVisible(e.getName().equals(bandName));
            }
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        Element[] elements = event.getReport().getItemBand().getElementArray();
        String rootName = this.getBaseCard();
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i] instanceof Band) || !elements[i].getName().equals(rootName)) continue;
            this.selectBand((Band)elements[i]);
        }
    }

    public Object getValue() {
        return null;
    }

    public String getBaseCard() {
        return this.baseCard;
    }

    public void setBaseCard(String baseCard) {
        this.baseCard = baseCard;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPrepaid() {
        return this.prepaid;
    }

    public void setPrepaid(String prepaid) {
        this.prepaid = prepaid;
    }

    public String getFree() {
        return this.free;
    }

    public void setFree(String free) {
        this.free = free;
    }

    public String getEmpty() {
        return this.empty;
    }

    public void setEmpty(String empty) {
        this.empty = empty;
    }

    protected String getBandForCardType(CardType ct) {
        if (CardType.ACCOUNT == ct) {
            return this.getAccount();
        }
        if (CardType.ADMIN == ct) {
            return this.getAdmin();
        }
        if (CardType.FREE == ct) {
            return this.getFree();
        }
        if (CardType.PREPAID == ct) {
            return this.getPrepaid();
        }
        if (CardType.USER == ct) {
            return this.getUser();
        }
        return this.getFree();
    }
}

