/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.cards;

import java.awt.Window;
import java.net.URL;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.AccountCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.AdminCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.CardTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.FreeCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.PrepaidCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.UserCard;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.cards.WrappingTableModel;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class SimpleCardDemoHandler
extends AbstractXmlDemoHandler {
    private TableModel data;

    public SimpleCardDemoHandler() {
        CardTableModel model = new CardTableModel();
        model.addCard(new AdminCard("Jared", "Diamond", "NR123123", "login", "secret", new Date()));
        model.addCard(new FreeCard("NR123123", new Date()));
        model.addCard(new PrepaidCard("First Name", "Last Name", "NR123123"));
        model.addCard(new AccountCard("John", "Doe", "NR123123", "login", "secret"));
        model.addCard(new UserCard("Richard", "Helm", "NR123123", "login", "secret", new Date()));
        this.data = new WrappingTableModel(model, "C1_", "C2_");
    }

    @Override
    public String getDemoName() {
        return "Simple Card printing";
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"simple-usercards.html", SimpleCardDemoHandler.class);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"usercards.xml", SimpleCardDemoHandler.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        return report;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        SimpleCardDemoHandler handler = new SimpleCardDemoHandler();
        SimpleDemoFrame frame = new SimpleDemoFrame(handler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

