/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.cards;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class WrappingTableModel
implements TableModel {
    private TableEventTranslator translator;
    private String columnPrefix1;
    private String columnPrefix2;
    private TableModel model;

    public WrappingTableModel(TableModel model) {
        this(model, "Column1_", "Column2_");
    }

    public WrappingTableModel(TableModel model, String prefix1, String prefix2) {
        if (prefix1 == null) {
            throw new NullPointerException();
        }
        if (prefix2 == null) {
            throw new NullPointerException();
        }
        if (prefix1.equals(prefix2)) {
            throw new IllegalArgumentException("Prefix 1 and 2 are identical");
        }
        this.model = model;
        this.columnPrefix1 = prefix1;
        this.columnPrefix2 = prefix2;
        this.translator = new TableEventTranslator();
    }

    public String getColumnPrefix1() {
        return this.columnPrefix1;
    }

    public String getColumnPrefix2() {
        return this.columnPrefix2;
    }

    @Override
    public int getRowCount() {
        return (int)Math.ceil((double)this.model.getRowCount() / 2.0);
    }

    @Override
    public int getColumnCount() {
        return 2 * this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        int tmpColumnIndex = columnIndex % this.model.getColumnCount();
        if (columnIndex < this.model.getColumnCount()) {
            return this.getColumnPrefix1() + this.model.getColumnName(tmpColumnIndex);
        }
        return this.getColumnPrefix2() + this.model.getColumnName(tmpColumnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        int tmpColumnIndex = columnIndex % this.model.getColumnCount();
        return this.model.getColumnClass(tmpColumnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int tmpColumnIndex = columnIndex % this.model.getColumnCount();
        int tmpRowIndex = this.calculateRow(rowIndex, columnIndex);
        if (tmpRowIndex >= this.model.getRowCount()) {
            return false;
        }
        return this.model.isCellEditable(tmpRowIndex, tmpColumnIndex);
    }

    private int calculateRow(int row, int column) {
        if (column < this.model.getColumnCount()) {
            return row * 2;
        }
        return row * 2 + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int tmpColumnIndex = columnIndex % this.model.getColumnCount();
        int tmpRowIndex = this.calculateRow(rowIndex, columnIndex);
        if (tmpRowIndex >= this.model.getRowCount()) {
            return null;
        }
        return this.model.getValueAt(tmpRowIndex, tmpColumnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int tmpColumnIndex = columnIndex % this.model.getColumnCount();
        int tmpRowIndex = this.calculateRow(rowIndex, columnIndex);
        if (tmpRowIndex >= this.model.getRowCount()) {
            return;
        }
        this.model.setValueAt(aValue, tmpRowIndex, tmpColumnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.translator.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.translator.removeTableModelListener(l);
    }

    private class TableEventTranslator
    implements TableModelListener {
        private final ArrayList listeners = new ArrayList();

        @Override
        public void tableChanged(TableModelEvent e) {
            int columnIndex = -1;
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            int firstRowIndex = firstRow / 2;
            int lastRowIndex = lastRow / 2;
            TableModelEvent event = new TableModelEvent(WrappingTableModel.this, firstRowIndex, lastRowIndex, -1, e.getType());
            for (int i = 0; i < this.listeners.size(); ++i) {
                TableModelListener l = (TableModelListener)this.listeners.get(i);
                l.tableChanged(event);
            }
        }

        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }
    }
}

