/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.chartdemo;

import java.awt.Color;
import java.awt.Paint;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.chartdemo.BasicExtXmlChartDemo;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class BasicSimpleXmlChartDemo
extends AbstractXmlDemoHandler {
    @Override
    public String getDemoName() {
        return "Basic JFreeChart Demo (Simple-XML)";
    }

    private PieDataset createSampleDataset() {
        DefaultPieDataset result = new DefaultPieDataset();
        result.setValue((Comparable)((Object)"Java"), (Number)new Double(43.2));
        result.setValue((Comparable)((Object)"Visual Basic"), (Number)new Double(10.0));
        result.setValue((Comparable)((Object)"C/C++"), (Number)new Double(17.5));
        result.setValue((Comparable)((Object)"PHP"), (Number)new Double(32.5));
        result.setValue((Comparable)((Object)"Perl"), (Number)new Double(0.0));
        return result;
    }

    private JFreeChart createChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)"Pie Chart 3D Demo 1", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.yellow);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setStartAngle(270.0);
        plot.setForegroundAlpha(0.5f);
        plot.setNoDataMessage("No data to display");
        return chart;
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        PieDataset dataset = this.createSampleDataset();
        JFreeChart chart = this.createChart(dataset);
        report.getParameterValues().put("Chart", (Object)chart);
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"basic-chart.html", BasicExtXmlChartDemo.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return new JPanel();
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"basic-chart-simple.xml", BasicExtXmlChartDemo.class);
    }
}

