/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.form;

import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.form.Patient;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.form.Treatment;

public class PatientTableModel
extends AbstractTableModel {
    private static Class[] COLUMN_TYPES = new Class[]{Patient.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Date.class, String.class, String.class, String.class};
    private static String[] COLUMN_NAMES = new String[]{"patient", "patient.name", "patient.address", "patient.town", "patient.ssn", "patient.insurance", "patient.symptoms", "patient.allergy", "patient.level", "treatment.date", "treatment.description", "treatment.medication", "treatment.success"};
    private ArrayList patients = new ArrayList();
    private int totalSize;
    private transient Patient[] patientPerRow;
    private transient Treatment[] treatmentPerRow;

    public void addPatient(Patient patient) {
        this.patients.add(patient);
        this.invalidateCaches();
        this.fireTableDataChanged();
    }

    public void removePatient(Patient patient) {
        this.patients.remove(patient);
        this.invalidateCaches();
        this.fireTableDataChanged();
    }

    public Patient getPatient(int patient) {
        return (Patient)this.patients.get(patient);
    }

    public void invalidateCaches() {
        int size = 0;
        for (int i = 0; i < this.patients.size(); ++i) {
            Patient p = this.getPatient(i);
            size += p.getTreatmentCount();
        }
        this.totalSize = size;
        this.patientPerRow = null;
        this.treatmentPerRow = null;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.totalSize;
    }

    private void fillCache() {
        if (this.treatmentPerRow != null && this.patientPerRow != null) {
            return;
        }
        this.treatmentPerRow = new Treatment[this.totalSize];
        this.patientPerRow = new Patient[this.totalSize];
        int currentRow = 0;
        int patientSize = this.patients.size();
        for (int i = 0; i < patientSize; ++i) {
            Patient pat = (Patient)this.patients.get(i);
            int treatmentCount = pat.getTreatmentCount();
            for (int tc = 0; tc < treatmentCount; ++tc) {
                this.patientPerRow[currentRow] = pat;
                this.treatmentPerRow[currentRow] = pat.getTreatment(tc);
                ++currentRow;
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.fillCache();
        Patient pat = this.patientPerRow[rowIndex];
        Treatment trm = this.treatmentPerRow[rowIndex];
        switch (columnIndex) {
            case 0: {
                return pat;
            }
            case 1: {
                return pat.getName();
            }
            case 2: {
                return pat.getAddress();
            }
            case 3: {
                return pat.getTown();
            }
            case 4: {
                return pat.getSsn();
            }
            case 5: {
                return pat.getInsurance();
            }
            case 6: {
                return pat.getSymptoms();
            }
            case 7: {
                return pat.getAllergy();
            }
            case 8: {
                return pat.getLevel();
            }
            case 9: {
                return trm.getDate();
            }
            case 10: {
                return trm.getDescription();
            }
            case 11: {
                return trm.getMedication();
            }
            case 12: {
                return trm.getSuccess();
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

