/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.functions;

import java.awt.Window;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.functions.WayBillTableModel;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class WayBillDemoHandler
extends AbstractXmlDemoHandler {
    private WayBillTableModel tableModel = new WayBillTableModel();

    public WayBillDemoHandler() {
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container A", "Glass Pearls", "Fragile", 5000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container A", "Chinese Silk", "Keep Dry", 1000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container A", "Incense", "", 1000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container B", "Palladium", "", 1000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container B", "Tungsten", "", 1000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container B", "Grain", "Keep Dry", 1000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Container B", "Scottish Whiskey", "Stay Dry!", 1000.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Notes", "Note", "This freight is dutyable.", 0.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Notes", "Note", "Customs paid on 2005-08-12 12:00.", 0.0));
        this.tableModel.addItem(new WayBillTableModel.CategoryItem("Notes", "Note", "Customs bill id: NY-A32ZY48473", 0.0));
    }

    @Override
    public String getDemoName() {
        return "Way-Bill Demo";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)this.tableModel));
        return report;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"waybill.html", WayBillDemoHandler.class);
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.tableModel);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"waybill.xml", WayBillDemoHandler.class);
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        WayBillDemoHandler demoHandler = new WayBillDemoHandler();
        SimpleDemoFrame frame = new SimpleDemoFrame(demoHandler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

