/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.functions;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class WayBillTableModel
extends AbstractTableModel {
    private String[] COLNAMES = new String[]{"Container", "Item", "Notes", "Weight"};
    private ArrayList rows = new ArrayList();

    public void addItem(CategoryItem item) {
        this.rows.add(item);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLNAMES.length;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 3) {
            return Double.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.COLNAMES[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CategoryItem item = (CategoryItem)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getContainer();
            }
            case 1: {
                return item.getItem();
            }
            case 2: {
                return item.getNotes();
            }
            case 3: {
                return item.getWeight();
            }
        }
        return null;
    }

    public static class CategoryItem {
        private String container;
        private String item;
        private String notes;
        private Double weight;

        public CategoryItem(String category, String item, String notes, double weight) {
            this.container = category;
            this.item = item;
            this.notes = notes;
            this.weight = new Double(weight);
        }

        public Double getWeight() {
            return this.weight;
        }

        public String getContainer() {
            return this.container;
        }

        public String getItem() {
            return this.item;
        }

        public String getNotes() {
            return this.notes;
        }
    }
}

