/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.huge;

import java.awt.Color;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class HugeLetterAndColorTableModel
extends AbstractTableModel {
    private TreeMap colors = new TreeMap();
    private String[] colorNames;
    private int rowCount;
    private static final String[] ONES_NAMES = new String[]{" one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};
    private static final String[] TENS_NAMES = new String[]{" twenty", " thirty", " forty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private static final String[] GROUPS = new String[]{"", " thousand", " million", " billion", " trillion", " quadrillion", " quintillion"};

    public HugeLetterAndColorTableModel() {
        this.colors.put("AliceBlue", new Color(0xF0F8FF));
        this.colors.put("AntiqueWhite", new Color(16444375));
        this.colors.put("Aqua", new Color(65535));
        this.colors.put("Aquamarine", new Color(8388564));
        this.colors.put("Azure", new Color(0xF0FFFF));
        this.colors.put("Beige", new Color(16119260));
        this.colors.put("Bisque", new Color(16770244));
        this.colors.put("Black", new Color(0));
        this.colors.put("BlanchedAlmond", new Color(16772045));
        this.colors.put("Blue", new Color(255));
        this.colors.put("BlueViolet", new Color(9055202));
        this.colors.put("Brown", new Color(0xA52A2A));
        this.colors.put("BurlyWood", new Color(14596231));
        this.colors.put("CadetBlue", new Color(6266528));
        this.colors.put("Chartreuse", new Color(0x7FFF00));
        this.colors.put("Chocolate", new Color(13789470));
        this.colors.put("Coral", new Color(16744272));
        this.colors.put("CornflowerBlue", new Color(6591981));
        this.colors.put("Cornsilk", new Color(16775388));
        this.colors.put("Crimson", new Color(14423100));
        this.colors.put("Cyan", new Color(65535));
        this.colors.put("DarkBlue", new Color(139));
        this.colors.put("DarkCyan", new Color(35723));
        this.colors.put("DarkGoldenRod", new Color(12092939));
        this.colors.put("DarkGray", new Color(0xA9A9A9));
        this.colors.put("DarkGreen", new Color(25600));
        this.colors.put("DarkKhaki", new Color(12433259));
        this.colors.put("DarkMagenta", new Color(0x8B008B));
        this.colors.put("DarkOliveGreen", new Color(5597999));
        this.colors.put("Darkorange", new Color(16747520));
        this.colors.put("DarkOrchid", new Color(10040012));
        this.colors.put("DarkRed", new Color(0x8B0000));
        this.colors.put("DarkSalmon", new Color(15308410));
        this.colors.put("DarkSeaGreen", new Color(9419919));
        this.colors.put("DarkSlateBlue", new Color(4734347));
        this.colors.put("DarkSlateGray", new Color(0x2F4F4F));
        this.colors.put("DarkTurquoise", new Color(52945));
        this.colors.put("DarkViolet", new Color(9699539));
        this.colors.put("DeepPink", new Color(16716947));
        this.colors.put("DeepSkyBlue", new Color(49151));
        this.colors.put("DimGray", new Color(0x696969));
        this.colors.put("DodgerBlue", new Color(2003199));
        this.colors.put("Feldspar", new Color(13734517));
        this.colors.put("FireBrick", new Color(0xB22222));
        this.colors.put("FloralWhite", new Color(0xFFFAF0));
        this.colors.put("ForestGreen", new Color(0x228B22));
        this.colors.put("Fuchsia", new Color(0xFF00FF));
        this.colors.put("Gainsboro", new Color(0xDCDCDC));
        this.colors.put("GhostWhite", new Color(0xF8F8FF));
        this.colors.put("Gold", new Color(16766720));
        this.colors.put("GoldenRod", new Color(14329120));
        this.colors.put("Gray", new Color(0x808080));
        this.colors.put("Green", new Color(32768));
        this.colors.put("GreenYellow", new Color(11403055));
        this.colors.put("HoneyDew", new Color(0xF0FFF0));
        this.colors.put("HotPink", new Color(16738740));
        this.colors.put("IndianRed", new Color(0xCD5C5C));
        this.colors.put("Indigo", new Color(4915330));
        this.colors.put("Ivory", new Color(0xFFFFF0));
        this.colors.put("Khaki", new Color(15787660));
        this.colors.put("Lavender", new Color(15132410));
        this.colors.put("LavenderBlush", new Color(0xFFF0F5));
        this.colors.put("LawnGreen", new Color(8190976));
        this.colors.put("LemonChiffon", new Color(16775885));
        this.colors.put("LightBlue", new Color(11393254));
        this.colors.put("LightCoral", new Color(0xF08080));
        this.colors.put("LightCyan", new Color(0xE0FFFF));
        this.colors.put("LightGoldenRodYellow", new Color(16448210));
        this.colors.put("LightGrey", new Color(0xD3D3D3));
        this.colors.put("LightGreen", new Color(0x90EE90));
        this.colors.put("LightPink", new Color(16758465));
        this.colors.put("LightSalmon", new Color(16752762));
        this.colors.put("LightSeaGreen", new Color(2142890));
        this.colors.put("LightSkyBlue", new Color(8900346));
        this.colors.put("LightSlateBlue", new Color(8679679));
        this.colors.put("LightSlateGray", new Color(0x778899));
        this.colors.put("LightSteelBlue", new Color(11584734));
        this.colors.put("LightYellow", new Color(0xFFFFE0));
        this.colors.put("Lime", new Color(65280));
        this.colors.put("LimeGreen", new Color(3329330));
        this.colors.put("Linen", new Color(16445670));
        this.colors.put("Magenta", new Color(0xFF00FF));
        this.colors.put("Maroon", new Color(0x800000));
        this.colors.put("MediumAquaMarine", new Color(6737322));
        this.colors.put("MediumBlue", new Color(205));
        this.colors.put("MediumOrchid", new Color(12211667));
        this.colors.put("MediumPurple", new Color(9662680));
        this.colors.put("MediumSeaGreen", new Color(3978097));
        this.colors.put("MediumSlateBlue", new Color(8087790));
        this.colors.put("MediumSpringGreen", new Color(64154));
        this.colors.put("MediumTurquoise", new Color(4772300));
        this.colors.put("MediumVioletRed", new Color(13047173));
        this.colors.put("MidnightBlue", new Color(1644912));
        this.colors.put("MintCream", new Color(0xF5FFFA));
        this.colors.put("MistyRose", new Color(16770273));
        this.colors.put("Moccasin", new Color(16770229));
        this.colors.put("NavajoWhite", new Color(16768685));
        this.colors.put("Navy", new Color(128));
        this.colors.put("OldLace", new Color(16643558));
        this.colors.put("Olive", new Color(0x808000));
        this.colors.put("OliveDrab", new Color(7048739));
        this.colors.put("Orange", new Color(16753920));
        this.colors.put("OrangeRed", new Color(16729344));
        this.colors.put("Orchid", new Color(14315734));
        this.colors.put("PaleGoldenRod", new Color(0xEEE8AA));
        this.colors.put("PaleGreen", new Color(10025880));
        this.colors.put("PaleTurquoise", new Color(0xAFEEEE));
        this.colors.put("PaleVioletRed", new Color(14184595));
        this.colors.put("PapayaWhip", new Color(16773077));
        this.colors.put("PeachPuff", new Color(16767673));
        this.colors.put("Peru", new Color(13468991));
        this.colors.put("Pink", new Color(16761035));
        this.colors.put("Plum", new Color(0xDDA0DD));
        this.colors.put("PowderBlue", new Color(11591910));
        this.colors.put("Purple", new Color(0x800080));
        this.colors.put("Red", new Color(0xFF0000));
        this.colors.put("RosyBrown", new Color(12357519));
        this.colors.put("RoyalBlue", new Color(4286945));
        this.colors.put("SaddleBrown", new Color(9127187));
        this.colors.put("Salmon", new Color(16416882));
        this.colors.put("SandyBrown", new Color(16032864));
        this.colors.put("SeaGreen", new Color(3050327));
        this.colors.put("SeaShell", new Color(0xFFF5EE));
        this.colors.put("Sienna", new Color(10506797));
        this.colors.put("Silver", new Color(0xC0C0C0));
        this.colors.put("SkyBlue", new Color(8900331));
        this.colors.put("SlateBlue", new Color(6970061));
        this.colors.put("SlateGray", new Color(7372944));
        this.colors.put("Snow", new Color(0xFFFAFA));
        this.colors.put("SpringGreen", new Color(65407));
        this.colors.put("SteelBlue", new Color(4620980));
        this.colors.put("Tan", new Color(13808780));
        this.colors.put("Teal", new Color(32896));
        this.colors.put("Thistle", new Color(14204888));
        this.colors.put("Tomato", new Color(16737095));
        this.colors.put("Turquoise", new Color(4251856));
        this.colors.put("Violet", new Color(0xEE82EE));
        this.colors.put("VioletRed", new Color(13639824));
        this.colors.put("Wheat", new Color(16113331));
        this.colors.put("White", new Color(0xFFFFFF));
        this.colors.put("WhiteSmoke", new Color(0xF5F5F5));
        this.colors.put("Yellow", new Color(0xFFFF00));
        this.colors.put("YellowGreen", new Color(10145074));
        this.colorNames = this.colors.keySet().toArray(new String[this.colors.size()]);
        this.rowCount = 200000;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        if (rowCount < 0) {
            throw new IllegalArgumentException();
        }
        this.rowCount = rowCount;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    public Class getColumnClass(int column) {
        if (column == 3) {
            return Integer.class;
        }
        if (column == 4) {
            return Double.class;
        }
        if (column == 5) {
            return Color.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Color";
        }
        if (column == 2) {
            return "Letter";
        }
        if (column == 3) {
            return "Integer";
        }
        if (column == 4) {
            return "Double";
        }
        if (column == 5) {
            return "ColorObject";
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.convertToEnglishNumber(row);
            }
            case 1: {
                return this.computeColorName(row);
            }
            case 2: {
                return this.computeLetter(row);
            }
            case 3: {
                return new Integer(1);
            }
            case 4: {
                return new Double(1.1);
            }
            case 5: {
                return this.colors.get(this.computeColorName(row));
            }
        }
        throw new IllegalArgumentException("Unexcpected column.");
    }

    private String computeLetter(int row) {
        int idx = row / 100 % 24;
        return "" + (char)(65 + idx);
    }

    private String computeColorName(int row) {
        int idx = row / 1000 % this.colorNames.length;
        return this.colorNames[idx];
    }

    private String convertToEnglishNumber(long n) {
        StringBuffer result = new StringBuffer();
        for (int i = GROUPS.length - 1; i >= 0; --i) {
            long cutoff = (long)Math.pow(10.0, (double)i * 3.0);
            if (n < cutoff) continue;
            int thisPart = (int)(n / cutoff);
            if (thisPart >= 100) {
                result.append(ONES_NAMES[thisPart / 100 - 1]);
                result.append(" hundred");
                thisPart %= 100;
            }
            if (thisPart >= 20) {
                result.append(TENS_NAMES[thisPart / 10 - 2]);
                thisPart %= 10;
            }
            if (thisPart >= 1) {
                result.append(ONES_NAMES[thisPart - 1]);
            }
            result.append(GROUPS[i]);
            n %= cutoff;
        }
        if (result.length() == 0) {
            return "zero";
        }
        return result.substring(1);
    }
}

