/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model;

import java.util.ArrayList;
import java.util.Date;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Article;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.invoice.model.Customer;

public class Advertising {
    private Customer customer;
    private ArrayList articles;
    private ArrayList articleReducedPrices;
    private Date date;
    private String adNumber;

    public Advertising(Customer customer, Date date, String adNumber) {
        if (customer == null) {
            throw new NullPointerException("The customer must not be null.");
        }
        if (date == null) {
            throw new NullPointerException("The date for the ad must not be null.");
        }
        if (adNumber == null) {
            throw new NullPointerException("The Advertising Number must not be null.");
        }
        this.customer = customer;
        this.date = date;
        this.adNumber = adNumber;
        this.articles = new ArrayList();
        this.articleReducedPrices = new ArrayList();
    }

    public synchronized void addArticle(Article article, double reduced) {
        if (article == null) {
            throw new NullPointerException("The given article must not be null");
        }
        int index = this.articles.indexOf(article);
        if (index == -1) {
            this.articles.add(article);
            this.articleReducedPrices.add(new Double(reduced));
        }
    }

    public synchronized void removeArticle(Article article) {
        if (article == null) {
            throw new NullPointerException("Article must not be null.");
        }
        int index = this.articles.indexOf(article);
        if (index != -1) {
            this.articleReducedPrices.remove(index);
            this.articles.remove(index);
        }
    }

    public Article getArticle(int index) {
        return (Article)this.articles.get(index);
    }

    public double getArticleReducedPrice(int index) {
        Double i = (Double)this.articleReducedPrices.get(index);
        return i;
    }

    public int getArticleCount() {
        return this.articles.size();
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAdNumber() {
        return this.adNumber;
    }
}

