/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts;

import java.awt.Window;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.DemoReportController;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoFrame;
import org.pentaho.reporting.engine.classic.demo.util.InternalDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class PropertyUpdatePreviewHandler
implements PreviewHandler {
    private static final Log logger = LogFactory.getLog(PropertyUpdatePreviewHandler.class);
    private InternalDemoHandler handler;

    public PropertyUpdatePreviewHandler(InternalDemoHandler handler) {
        this.handler = handler;
    }

    @Override
    public void attemptPreview() {
        try {
            MasterReport report = this.handler.createReport();
            PreviewDialog frame = new PreviewDialog(report);
            frame.setToolbarFloatable(true);
            frame.setReportController((ReportController)new DemoReportController());
            frame.pack();
            LibSwingUtil.positionFrameRandomly((Window)frame);
            frame.setVisible(true);
            frame.requestFocus();
        }
        catch (ReportDefinitionException e) {
            logger.error((Object)"Unable to create the report; report definition contained errors.", (Throwable)e);
            AbstractDemoFrame.showExceptionDialog(this.handler.getPresentationComponent(), "report.definitionfailure", e);
        }
    }
}

