/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts;

import java.awt.Color;
import java.awt.Window;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.JComponent;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.DemoTextInputPanel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.PropertyUpdatePreviewHandler;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.layouts.StackedLayoutXMLDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class StackedLayoutAPIDemoHandler
extends AbstractDemoHandler {
    private DemoTextInputPanel inputPanel = new DemoTextInputPanel();
    private PropertyUpdatePreviewHandler previewHandler = new PropertyUpdatePreviewHandler(this);

    @Override
    public JComponent getPresentationComponent() {
        return this.inputPanel;
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = new MasterReport();
        ReportHeader reportHeader = report.getReportHeader();
        report.setName(this.getDemoName());
        TextFieldElementFactory factory = new TextFieldElementFactory();
        factory.setName("T1");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        factory.setMinimumSize((Dimension2D)new FloatDimension(150.0f, 12.0f));
        factory.setColor(Color.black);
        factory.setHorizontalAlignment(ElementAlignment.RIGHT);
        factory.setVerticalAlignment(ElementAlignment.MIDDLE);
        factory.setNullString("-");
        factory.setFieldname("Message1");
        factory.setDynamicHeight(Boolean.TRUE);
        reportHeader.addElement(factory.createElement());
        factory.setName("T2");
        factory.setAbsolutePosition((Point2D)new Point2D.Float(200.0f, 0.0f));
        factory.setHorizontalAlignment(ElementAlignment.LEFT);
        factory.setFieldname("Message2");
        reportHeader.addElement(factory.createElement());
        DefaultParameterDefinition paramDef = new DefaultParameterDefinition();
        paramDef.addParameterDefinition((ParameterDefinitionEntry)new PlainParameter("Message1", String.class));
        paramDef.addParameterDefinition((ParameterDefinitionEntry)new PlainParameter("Message2", String.class));
        report.getParameterValues().put("Message1", (Object)this.inputPanel.getMessageOne());
        report.getParameterValues().put("Message2", (Object)this.inputPanel.getMessageTwo());
        return report;
    }

    @Override
    public String getDemoName() {
        return "Stacked Layout Manager Demo (API)";
    }

    @Override
    public PreviewHandler getPreviewHandler() {
        return this.previewHandler;
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"stacked-layout.html", StackedLayoutXMLDemoHandler.class);
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        StackedLayoutAPIDemoHandler demoHandler = new StackedLayoutAPIDemoHandler();
        SimpleDemoFrame frame = new SimpleDemoFrame(demoHandler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }
}

