/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.nogui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StreamCSVOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.RTFReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.ExcelReportUtil;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;

public class StraightToEverything {
    private static final Log logger = LogFactory.getLog(StraightToEverything.class);

    public StraightToEverything(String filename) throws ParseException {
        URL in = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/opensource.xml", StraightToEverything.class);
        MasterReport report = this.parseReport(in);
        OpenSourceProjects data = new OpenSourceProjects();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)data));
        try {
            StraightToEverything.createPDF(report, filename + ".pdf");
            StraightToEverything.createCSV(report, filename + ".csv");
            StraightToEverything.createDirectoryHTML(report, filename + ".html");
            StraightToEverything.createPlainText(report, filename + ".txt");
            StraightToEverything.createRTF(report, filename + ".rtf");
            StraightToEverything.createStreamHTML(report, filename + "-single-file.html");
            StraightToEverything.createXLS(report, filename + ".xls");
            StraightToEverything.createZIPHTML(report, filename + ".zip");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to write report", (Throwable)e);
        }
    }

    private MasterReport parseReport(URL templateURL) throws ParseException {
        try {
            ResourceManager mgr = new ResourceManager();
            Resource resource = mgr.createDirectly((Object)templateURL, MasterReport.class);
            return (MasterReport)resource.getResource();
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse the report", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createPDF(MasterReport report, String fileName) {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
            PdfOutputProcessor outputProcessor = new PdfOutputProcessor(report.getConfiguration(), out, report.getResourceManager());
            PageableReportProcessor proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
            proc.processReport();
            proc.close();
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Writing PDF failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Saving PDF failed.", (Throwable)e);
            }
        }
    }

    public static void createPlainText(MasterReport report, String filename) throws Exception {
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename));
        TextFilePrinterDriver pc = new TextFilePrinterDriver((OutputStream)fout, 15.0f, 10.0f);
        PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor((PrinterDriver)pc, report.getConfiguration());
        PageableReportProcessor proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
        proc.processReport();
        proc.close();
        ((OutputStream)fout).close();
    }

    public static void createRTF(MasterReport report, String filename) throws Exception {
        RTFReportUtil.createRTF((MasterReport)report, (String)filename);
    }

    public static void createCSV(MasterReport report, String filename) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filename));
        StreamCSVOutputProcessor target = new StreamCSVOutputProcessor((OutputStream)outputStream);
        StreamReportProcessor reportProcessor = new StreamReportProcessor(report, (OutputProcessor)target);
        reportProcessor.processReport();
        ((OutputStream)outputStream).close();
    }

    public static void createXLS(MasterReport report, String filename) throws Exception {
        ExcelReportUtil.createXLS((MasterReport)report, (String)filename);
    }

    public static void createStreamHTML(MasterReport report, String filename) throws Exception {
        HtmlReportUtil.createStreamHTML((MasterReport)report, (String)filename);
    }

    public static void createDirectoryHTML(MasterReport report, String filename) throws Exception {
        HtmlReportUtil.createDirectoryHTML((MasterReport)report, (String)filename);
    }

    public static void createZIPHTML(MasterReport report, String filename) throws Exception {
        HtmlReportUtil.createZIPHTML((MasterReport)report, (String)filename);
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        try {
            String folder = args.length == 0 ? System.getProperty("user.home") : args[0];
            new StraightToEverything(folder + "/OpenSource-Demo");
            System.exit(0);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to run demo", (Throwable)e);
            System.exit(1);
        }
    }
}

