/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.nogui;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;

public class StraightToPDF {
    private static final Log logger = LogFactory.getLog(StraightToPDF.class);

    public StraightToPDF(String filename) throws ParseException {
        URL in = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/opensource.xml", StraightToPDF.class);
        MasterReport report = this.parseReport(in);
        OpenSourceProjects data = new OpenSourceProjects();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)data));
        long startTime = System.currentTimeMillis();
        this.savePDF(report, filename);
    }

    private MasterReport parseReport(URL templateURL) throws ParseException {
        try {
            ResourceManager mgr = new ResourceManager();
            Resource resource = mgr.createDirectly((Object)templateURL, MasterReport.class);
            MasterReport report = (MasterReport)resource.getResource();
            URL imageURL = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/gorilla.jpg", StraightToPDF.class);
            Image image = Toolkit.getDefaultToolkit().createImage(imageURL);
            WaitingImageObserver obs = new WaitingImageObserver(image);
            obs.waitImageLoaded();
            report.getParameterValues().put("logo", (Object)image);
            return report;
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse the report", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePDF(MasterReport report, String fileName) {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
            PdfOutputProcessor outputProcessor = new PdfOutputProcessor(report.getConfiguration(), out, report.getResourceManager());
            PageableReportProcessor proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
            proc.processReport();
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.err.println("Writing PDF failed.");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                System.err.println("Saving PDF failed.");
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        try {
            new StraightToPDF(System.getProperty("user.home") + "/OpenSource-Demo.pdf");
            System.exit(0);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to run demo", (Throwable)e);
            System.exit(1);
        }
    }
}

