/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.nogui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.xml.XMLProcessor;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;

public class StraightToXML {
    private static final Log logger = LogFactory.getLog(StraightToXML.class);

    public StraightToXML(String filename) throws ParseException {
        URL in = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/demo/opensource/opensource.xml", StraightToXML.class);
        MasterReport report = this.parseReport(in);
        OpenSourceProjects data = new OpenSourceProjects();
        report.setDataFactory((DataFactory)new TableDataFactory("default", (TableModel)data));
        this.saveXML(report, filename);
    }

    private MasterReport parseReport(URL templateURL) throws ParseException {
        try {
            ResourceManager mgr = new ResourceManager();
            Resource resource = mgr.createDirectly((Object)templateURL, MasterReport.class);
            return (MasterReport)resource.getResource();
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse the report", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveXML(MasterReport report, String fileName) {
        Writer out = null;
        try {
            out = new BufferedWriter(new FileWriter(new File(fileName)));
            XMLProcessor xprc = new XMLProcessor(report);
            xprc.setWriter(out);
            xprc.processReport();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.err.println("Writing PDF failed.");
            System.err.println(e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                System.err.println("Saving XML failed.");
                System.err.println(e.toString());
            }
        }
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        try {
            new StraightToXML(System.getProperty("user.home") + "/OpenSource-Demo.xml");
            System.exit(0);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to run demo", (Throwable)e);
            System.exit(1);
        }
    }
}

