/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.onetomany;

import java.awt.BasicStroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.elementfactory.HorizontalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.LabelElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.HideElementByNameFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class OfficeReportDefinition {
    private MasterReport report;

    public OfficeReportDefinition(MasterReport report) {
        this.report = report;
    }

    public void configure() {
        this.configureRecordGroup();
        this.configureItemBand();
        this.configureFunctions();
    }

    private void configureRecordGroup() {
        Band b = new Band();
        b.setName("office");
        b.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)Boolean.TRUE);
        b.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"SansSerif");
        b.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(12));
        LabelElementFactory labelFactory = new LabelElementFactory();
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(200.0f, 15.0f));
        labelFactory.setText("People in the same office:");
        b.addElement(labelFactory.createElement());
        labelFactory = new LabelElementFactory();
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Float(200.0f, 0.0f));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 15.0f));
        labelFactory.setText("Notes:");
        b.addElement(labelFactory.createElement());
        Element line = HorizontalLineElementFactory.createHorizontalLine((float)15.0f);
        line.getStyle().setStyleProperty(ElementStyleKeys.STROKE, (Object)new BasicStroke(1.0f));
        b.addElement(line);
        RelationalGroup group = this.report.getGroupByName("record-group");
        group.getHeader().addElement((Element)b);
    }

    private void configureItemBand() {
        Band b = new Band();
        b.setName("office");
        b.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)Boolean.FALSE);
        b.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)"SansSerif");
        b.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        TextFieldElementFactory textFieldFactory = new TextFieldElementFactory();
        textFieldFactory.setFieldname("office.Name");
        textFieldFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        textFieldFactory.setMinimumSize((Dimension2D)new FloatDimension(200.0f, 12.0f));
        b.addElement(textFieldFactory.createElement());
        textFieldFactory = new TextFieldElementFactory();
        textFieldFactory.setFieldname("office.Annotations");
        textFieldFactory.setAbsolutePosition((Point2D)new Point2D.Float(200.0f, 0.0f));
        textFieldFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 12.0f));
        textFieldFactory.setDynamicHeight(Boolean.TRUE);
        b.addElement(textFieldFactory.createElement());
        this.report.getItemBand().addElement((Element)b);
    }

    private void configureFunctions() {
        HideElementByNameFunction function = new HideElementByNameFunction();
        function.setName("hideOffice");
        function.setField("recordType");
        function.setElement("office");
        this.report.addExpression((Expression)function);
    }
}

