/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.onetomany;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.elementfactory.DateFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.HorizontalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.LabelElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.PageOfPagesFunction;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.onetomany.ActivityReportDefinition;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.onetomany.LunchReportDefinition;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.onetomany.OfficeReportDefinition;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class PeopleReportDefinition {
    private MasterReport report = new MasterReport();

    public PeopleReportDefinition() {
        this.report.setName("People Report (API)");
        this.configurePeopleGroup();
        this.configureRecordGroup();
        ActivityReportDefinition activityDef = new ActivityReportDefinition(this.report);
        activityDef.configure();
        LunchReportDefinition lunchDef = new LunchReportDefinition(this.report);
        lunchDef.configure();
        OfficeReportDefinition officeDef = new OfficeReportDefinition(this.report);
        officeDef.configure();
        this.configurePageHeader();
        this.configurePageFooter();
        this.configureFunctions();
    }

    private void configureFunctions() {
        PageOfPagesFunction pageFunction = new PageOfPagesFunction();
        pageFunction.setName("pageXofY");
        pageFunction.setFormat("Page {0} of {1}");
        this.report.addExpression((Expression)pageFunction);
    }

    private void configurePeopleGroup() {
        RelationalGroup group = new RelationalGroup();
        group.setName("person-group");
        group.addField("person.name");
        LabelElementFactory labelFactory = new LabelElementFactory();
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 0.0f));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(160.0f, 12.0f));
        labelFactory.setText("Name:");
        group.getHeader().addElement(labelFactory.createElement());
        TextFieldElementFactory textFieldFactory = new TextFieldElementFactory();
        textFieldFactory.setFieldname("person.name");
        textFieldFactory.setAbsolutePosition((Point2D)new Point2D.Float(170.0f, 0.0f));
        textFieldFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 12.0f));
        group.getHeader().addElement(textFieldFactory.createElement());
        labelFactory = new LabelElementFactory();
        labelFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 15.0f));
        labelFactory.setMinimumSize((Dimension2D)new FloatDimension(160.0f, 12.0f));
        labelFactory.setText("Address:");
        group.getHeader().addElement(labelFactory.createElement());
        textFieldFactory = new TextFieldElementFactory();
        textFieldFactory.setFieldname("person.address");
        textFieldFactory.setAbsolutePosition((Point2D)new Point2D.Float(170.0f, 15.0f));
        textFieldFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, 12.0f));
        group.getHeader().addElement(textFieldFactory.createElement());
        group.getFooter().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(15.0f));
        this.report.addGroup(group);
    }

    private void configureRecordGroup() {
        RelationalGroup group = new RelationalGroup();
        group.setName("record-group");
        group.addField("person.name");
        group.addField("recordType");
        this.report.addGroup(group);
    }

    private void configurePageHeader() {
        PageHeader pageHeader = this.report.getPageHeader();
        ElementStyleSheet style = pageHeader.getStyle();
        style.setStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, (Object)Boolean.TRUE);
        style.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(24.0f));
        style.setStyleProperty(TextStyleKeys.FONT, (Object)"Serif");
        style.setStyleProperty(TextStyleKeys.FONTSIZE, (Object)new Integer(10));
        style.setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)new Color(0xAFAFAF));
        pageHeader.addElement(HorizontalLineElementFactory.createHorizontalLine((float)18.0f, null, (Stroke)new BasicStroke(1.0f)));
        DateFieldElementFactory elementFactory = new DateFieldElementFactory();
        elementFactory.setAbsolutePosition((Point2D)new Point2D.Float(-50.0f, 0.0f));
        elementFactory.setMinimumSize((Dimension2D)new FloatDimension(-50.0f, -100.0f));
        elementFactory.setVerticalAlignment(ElementAlignment.MIDDLE);
        elementFactory.setHorizontalAlignment(ElementAlignment.RIGHT);
        elementFactory.setFormatString("d-MMM-yyyy");
        elementFactory.setFieldname("report.date");
        pageHeader.addElement(elementFactory.createElement());
    }

    private void configurePageFooter() {
        PageFooter pageFooter = this.report.getPageFooter();
        ElementStyleSheet style = pageFooter.getStyle();
        style.setStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, (Object)Boolean.TRUE);
        style.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(24.0f));
        style.setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)new Color(0xAFAFAF));
        pageFooter.addElement(HorizontalLineElementFactory.createHorizontalLine((float)0.0f, null, (Stroke)new BasicStroke(1.0f)));
        TextFieldElementFactory elementFactory = new TextFieldElementFactory();
        elementFactory.setAbsolutePosition((Point2D)new Point2D.Float(0.0f, 4.0f));
        elementFactory.setMinimumSize((Dimension2D)new FloatDimension(-100.0f, -100.0f));
        elementFactory.setVerticalAlignment(ElementAlignment.MIDDLE);
        elementFactory.setHorizontalAlignment(ElementAlignment.RIGHT);
        elementFactory.setFieldname("pageXofY");
        this.report.getPageFooter().addElement(elementFactory.createElement());
    }

    public MasterReport getReport() {
        return this.report;
    }
}

