/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewInternalFrame;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceXMLDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.AbstractDemoFrame;
import org.pentaho.reporting.engine.classic.demo.util.DemoController;
import org.pentaho.reporting.engine.classic.demo.util.PreviewHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.engine.classic.demo.util.SimpleDemoFrame;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class InternalFrameDemoHandler
extends OpenSourceXMLDemoHandler {
    private final TableModel data = new OpenSourceProjects();
    private JDesktopPane desktop;
    private PreviewHandler previewHandler = new InternalFramePreviewHandler();

    @Override
    public String getDemoName() {
        return "Internal Frame Demo (External)";
    }

    @Override
    public synchronized JComponent getPresentationComponent() {
        return this.getDesktop();
    }

    protected JDesktopPane getDesktop() {
        if (this.desktop == null) {
            this.desktop = this.init(this.getController());
        }
        return this.desktop;
    }

    private JDesktopPane init(DemoController ctrl) {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        content.add(this.createDefaultTable(this.data));
        content.add((Component)new JButton(ctrl.getExportAction()), "South");
        JInternalFrame frame = new JInternalFrame();
        frame.setClosable(false);
        frame.setVisible(true);
        frame.setContentPane(content);
        frame.pack();
        JDesktopPane desktop = new JDesktopPane();
        desktop.setDoubleBuffered(false);
        desktop.add(frame);
        return desktop;
    }

    @Override
    public PreviewHandler getPreviewHandler() {
        return this.previewHandler;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        InternalFrameDemoHandler handler = new InternalFrameDemoHandler();
        SimpleDemoFrame frame = new SimpleDemoFrame(handler);
        frame.init();
        frame.pack();
        LibSwingUtil.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }

    private class InternalFramePreviewHandler
    implements PreviewHandler {
        protected InternalFramePreviewHandler() {
        }

        @Override
        public void attemptPreview() {
            try {
                MasterReport report = InternalFrameDemoHandler.this.createReport();
                PreviewInternalFrame frame = new PreviewInternalFrame(report);
                frame.setClosable(true);
                frame.setResizable(true);
                frame.setToolbarFloatable(false);
                InternalFrameDemoHandler.this.getDesktop().add((Component)frame);
                frame.pack();
                frame.setVisible(true);
                frame.requestFocus();
            }
            catch (ReportDefinitionException e) {
                AbstractDemoFrame.showExceptionDialog(InternalFrameDemoHandler.this.desktop, "report.definitionfailure", e);
            }
        }
    }
}

