/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlReportUtil;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.opensource.OpenSourceProjects;
import org.pentaho.reporting.engine.classic.demo.util.AbstractXmlDemoHandler;
import org.pentaho.reporting.engine.classic.demo.util.ReportDefinitionException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class OpenSourceXMLDemoHandler
extends AbstractXmlDemoHandler {
    private TableModel data = new OpenSourceProjects();

    @Override
    public String getDemoName() {
        return "Open Source Demo (XML)";
    }

    @Override
    public MasterReport createReport() throws ReportDefinitionException {
        MasterReport report = this.parseReport();
        report.setDataFactory((DataFactory)new TableDataFactory("default", this.data));
        URL imageURL = ObjectUtilities.getResourceRelative((String)"gorilla.jpg", OpenSourceXMLDemoHandler.class);
        Image image = Toolkit.getDefaultToolkit().createImage(imageURL);
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        report.getParameterValues().put("logo", (Object)image);
        return report;
    }

    @Override
    public JComponent getPresentationComponent() {
        return this.createDefaultTable(this.data);
    }

    @Override
    public URL getDemoDescriptionSource() {
        return ObjectUtilities.getResourceRelative((String)"opensource-xml.html", OpenSourceXMLDemoHandler.class);
    }

    @Override
    public URL getReportDefinitionSource() {
        return ObjectUtilities.getResourceRelative((String)"opensource.xml", OpenSourceXMLDemoHandler.class);
    }

    public static void main(String[] args) throws ReportDefinitionException, ReportProcessingException, IOException {
        ClassicEngineBoot.getInstance().start();
        OpenSourceXMLDemoHandler handler = new OpenSourceXMLDemoHandler();
        HtmlReportUtil.createDirectoryHTML((MasterReport)handler.createReport(), (String)"/tmp/report.html");
    }
}

