/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.sportscouncil;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.sportscouncil.CouncilRecord;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.sportscouncil.LeaderRecord;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.sportscouncil.Organization;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.sportscouncil.SubOrganizationRecord;

public class SportsCouncilTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"recordID", "orgID", "council.orgName", "council.internalWebsite", "council.orgEmail", "council.street1", "council.street2", "council.city", "council.state", "council.zip", "council.phoneNumber", "council.extension", "council.faxNumber", "council.yearEventCount", "council.thisMonthEventCount", "council.lastMonthEventCount", "council.futureEventCount", "leader.firstName", "leader.lastName", "leader.position", "leader.leadershipPhoneNumber", "leader.email", "org.name", "org.email", "org.maleGenderCount", "org.femaleGenderCount"};
    private static final int COUNCIL_COLUMNS = 17;
    private static final Class[] COLUMN_TYPES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Number.class, Number.class, Number.class, Number.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Number.class, Number.class};
    private ArrayList columns = new ArrayList();

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] rowData = (Object[])this.columns.get(rowIndex);
        return rowData[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void copyInto(Organization org) {
        Object[] rowData;
        int i;
        Object[] councilData = new Object[17];
        CouncilRecord councilRecord = org.getCouncil();
        councilData[0] = councilRecord.getRecordType();
        councilData[1] = councilRecord.getOrgID();
        councilData[2] = councilRecord.getOrgName();
        councilData[3] = councilRecord.getInternalWebsite();
        councilData[4] = councilRecord.getOrgEmail();
        councilData[5] = councilRecord.getStreet1();
        councilData[6] = councilRecord.getStreet2();
        councilData[7] = councilRecord.getCity();
        councilData[8] = councilRecord.getState();
        councilData[9] = councilRecord.getZip();
        councilData[10] = councilRecord.getPhoneNumber();
        councilData[11] = councilRecord.getExtension();
        councilData[12] = councilRecord.getFaxNumber();
        councilData[13] = new Integer(councilRecord.getYearEventCount());
        councilData[14] = new Integer(councilRecord.getThisMonthEventCount());
        councilData[15] = new Integer(councilRecord.getLastMonthEventCount());
        councilData[16] = new Integer(councilRecord.getFutureEventCount());
        for (i = 0; i < org.getLeaderCount(); ++i) {
            rowData = new Object[COLUMN_NAMES.length];
            System.arraycopy(councilData, 0, rowData, 0, councilData.length);
            LeaderRecord leaderRecord = org.getLeader(i);
            rowData[0] = leaderRecord.getRecordType();
            rowData[17] = leaderRecord.getFirstName();
            rowData[18] = leaderRecord.getLastName();
            rowData[19] = leaderRecord.getPosition();
            rowData[20] = leaderRecord.getLeadershipPhoneNumber();
            rowData[21] = leaderRecord.getEmail();
            this.columns.add(rowData);
        }
        for (i = 0; i < org.getSubOrganzationsCount(); ++i) {
            rowData = new Object[COLUMN_NAMES.length];
            System.arraycopy(councilData, 0, rowData, 0, councilData.length);
            SubOrganizationRecord subOrganizationRecord = org.getSubOrganization(i);
            rowData[0] = subOrganizationRecord.getRecordType();
            rowData[22] = subOrganizationRecord.getName();
            rowData[23] = subOrganizationRecord.getEmail();
            rowData[24] = new Integer(subOrganizationRecord.getMaleGenderCount());
            rowData[25] = new Integer(subOrganizationRecord.getFemaleGenderCount());
            this.columns.add(rowData);
        }
    }

    public static SportsCouncilTableModel createDefaultModel() {
        CouncilRecord uuCouncilRecord = new CouncilRecord("1", "Unseen University Sports Council", "http://www.unseen-university.edu", "sportscouncil@unseen-university.edu", "Alberto Malich Plaza 1", "", "Ankh-Mopork", "AM", "88888", "(01 33) 5 85 38 56 36", "123", "(01 33) 5 85 38 99 99", 400, 35, 79, 111);
        Organization uuOrg = new Organization(uuCouncilRecord);
        uuOrg.addLeader(new LeaderRecord("1", "Mustrum", "Ridcully", "Archchancellor", "(01 33) 5 85 38 00 08", "big.boss@unseen-university.edu"));
        uuOrg.addLeader(new LeaderRecord("1", "Dr.", "Dinwiddie", "Bursar", "(01 33) 5 85 38 53 21", "bursar@unseen-university.edu"));
        uuOrg.addLeader(new LeaderRecord("1", "Windle", "Poons", "Wizzard", "(01 33) 5 85 38 12 36", "poons@unseen-university.edu"));
        SubOrganizationRecord sailors = new SubOrganizationRecord("1", "Sailing Club", "sailing@unseen-university.edu", 24, 28);
        uuOrg.addSubOrganization(sailors);
        SubOrganizationRecord daemonRiders = new SubOrganizationRecord("1", "Dungeon Dimension Explorers Club", "dungeons@unseen-university.edu", 44, 15);
        uuOrg.addSubOrganization(daemonRiders);
        SubOrganizationRecord dragonBreeders = new SubOrganizationRecord("1", "Dragon Breeders Club", "dragons@unseen-university.edu", 9, 29);
        uuOrg.addSubOrganization(dragonBreeders);
        CouncilRecord agCouncilRecord = new CouncilRecord("1", "Assasins Guild Council", "http://www.assassins-guild.com", "info@assassins-guild.edu", "Grand Plaza 2a", "", "Ankh-Mopork", "AM", "88213", "(01 33) 6 66 55 53 36", "0", "(01 33) 6 66 66 53 39", 200, 15, 49, 31);
        Organization org = new Organization(agCouncilRecord);
        org.addLeader(new LeaderRecord("1", "Dr. MD", "Downey", "President", "(01 33) 6 66 55 53 37", "big.boss@assassins-guild.edu"));
        org.addLeader(new LeaderRecord("1", "Zlorf", "Flannelfoot", "Vice-President", "(01 33) 6 66 55 53 32", "flannelfoot@assassins-guild.edu"));
        org.addLeader(new LeaderRecord("1", "Jonathan", "Teatime", "Assassin", "(01 33) 6 66 55 53 34", "teatime@assassins-guild.edu"));
        SubOrganizationRecord fenching = new SubOrganizationRecord("1", "Fencing Club", "fencing@assassins-guild.edu", 23, 22);
        org.addSubOrganization(fenching);
        SubOrganizationRecord camouflage = new SubOrganizationRecord("1", "Mask Chamber", "camouflage@assassins-guild.edu", 21, 23);
        org.addSubOrganization(camouflage);
        SubOrganizationRecord rangeWeapons = new SubOrganizationRecord("1", "Archer's Society", "bowmen@assassins-guild.edu", 13, 22);
        org.addSubOrganization(rangeWeapons);
        SportsCouncilTableModel tableModel = new SportsCouncilTableModel();
        tableModel.copyInto(org);
        tableModel.copyInto(uuOrg);
        return tableModel;
    }
}

