/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.swingicons;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action.AbstractFileSelectionAction;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStorage;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.swingicons.ImageCellRenderer;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.swingicons.SwingIconsDemoTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SwingIconsDemoPanel
extends JPanel {
    private static final Log logger = LogFactory.getLog(SwingIconsDemoPanel.class);
    private SwingIconsDemoTableModel data = new SwingIconsDemoTableModel();
    private static boolean warnedUser;

    public SwingIconsDemoPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JTable table = new JTable(this.data);
        table.setDefaultRenderer(Image.class, new ImageCellRenderer());
        table.setRowHeight(26);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(4));
        buttonPanel.add(new JButton((Action)((Object)new SelectRepositoryFileAction())));
        this.add((Component)buttonPanel, "South");
        this.loadData(this.findDataFile());
    }

    protected void loadData(URL sourceURL) {
        if (sourceURL != null) {
            if (this.data.readData(sourceURL)) {
                this.storeToConfiguration(sourceURL);
                return;
            }
            String message = "There was a problem while loading 'jlfgr-1_0.jar'.\nA URL was given, but the contents seems to be invalid.\n\nYou may download this jar-file from: \nhttp://java.sun.com/developer/techDocs/hi/repository/";
            logger.warn((Object)"There was a problem while loading 'jlfgr-1_0.jar'.\nA URL was given, but the contents seems to be invalid.\n\nYou may download this jar-file from: \nhttp://java.sun.com/developer/techDocs/hi/repository/");
        }
        this.data.clear();
        this.storeToConfiguration(null);
    }

    protected URL loadFromConfiguration() {
        String configPath = ConfigFactory.encodePath((String)"SwingIconsDemo-TableModel");
        ConfigStorage cs = ConfigFactory.getInstance().getUserStorage();
        if (!cs.isAvailable(configPath)) {
            return null;
        }
        try {
            Configuration p = cs.load(configPath, null);
            String property = p.getConfigProperty("repository-path");
            if (property == null) {
                return null;
            }
            return new URL(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void storeToConfiguration(URL url) {
        String configPath = ConfigFactory.encodePath((String)"SwingIconsDemo-TableModel");
        ConfigStorage cs = ConfigFactory.getInstance().getUserStorage();
        try {
            DefaultConfiguration p = new DefaultConfiguration();
            if (url != null) {
                p.setConfigProperty("repository-path", url.toExternalForm());
            }
            cs.store(configPath, (Configuration)p);
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to store the configuration.", (Throwable)e);
        }
    }

    private URL findDataFile() {
        File classpathFile;
        URL url = ObjectUtilities.getResource((String)"jlfgr-1_0.jar", SwingIconsDemoPanel.class);
        if (url != null) {
            return url;
        }
        URL urlFromConfig = this.loadFromConfiguration();
        if (urlFromConfig != null) {
            return urlFromConfig;
        }
        File localFile = new File("jlfgr-1_0.jar");
        if (localFile.exists() && localFile.canRead() && localFile.isFile()) {
            try {
                return localFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.warn((Object)"Unable to form local file URL. Is there no local filesystem?");
            }
        }
        if ((classpathFile = SwingIconsDemoPanel.findFileOnClassPath("jlfgr-1_0.jar")) != null && classpathFile.exists() && classpathFile.canRead() && classpathFile.isFile()) {
            try {
                return classpathFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.warn((Object)"Unable to form local file URL. Is there no local filesystem?");
            }
        }
        if (!warnedUser && !GraphicsEnvironment.isHeadless()) {
            warnedUser = true;
            String title = "Unable to load the icons.";
            String message = "Unable to find 'jlfgr-1_0.jar'\nPlease make sure you have the Java Look and Feel Graphics Repository in in your classpath, the same directory as the JFreeReport-jar files or in the current working directory.\n\nYou may download this jar-file from: \nhttp://java.sun.com/developer/techDocs/hi/repository/";
            JOptionPane.showMessageDialog(this, "Unable to find 'jlfgr-1_0.jar'\nPlease make sure you have the Java Look and Feel Graphics Repository in in your classpath, the same directory as the JFreeReport-jar files or in the current working directory.\n\nYou may download this jar-file from: \nhttp://java.sun.com/developer/techDocs/hi/repository/", "Unable to load the icons.", 0);
        }
        return null;
    }

    public static File findFileOnClassPath(String name) {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File target;
            String pathElement = tokenizer.nextToken();
            File directoryOrJar = new File(pathElement);
            File absoluteDirectoryOrJar = directoryOrJar.getAbsoluteFile();
            if (!(absoluteDirectoryOrJar.isFile() ? (target = new File(absoluteDirectoryOrJar.getParent(), name)).exists() : (target = new File(directoryOrJar, name)).exists())) continue;
            return target;
        }
        return null;
    }

    public SwingIconsDemoTableModel getData() {
        return this.data;
    }

    private class SelectRepositoryFileAction
    extends AbstractFileSelectionAction {
        private File selectedFile;

        protected SelectRepositoryFileAction() {
            super((Component)SwingIconsDemoPanel.this);
            this.putValue("Name", "Select graphics archive ..");
            this.putValue("SmallIcon", ImageUtils.createTransparentIcon((int)16, (int)16));
            this.putValue("ICON24", ImageUtils.createTransparentIcon((int)24, (int)24));
        }

        public void actionPerformed(ActionEvent e) {
            this.selectedFile = this.performSelectFile(this.selectedFile, 0, true);
            if (this.selectedFile != null && this.selectedFile.exists() && this.selectedFile.canRead() && this.selectedFile.isFile()) {
                try {
                    SwingIconsDemoPanel.this.loadData(this.selectedFile.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    logger.warn((Object)"Unable to form local file URL. Is there no local filesystem?");
                }
            }
        }

        protected String getFileDescription() {
            return "Java Look and Feel Graphics Repository";
        }

        protected String getFileExtension() {
            return ".jar";
        }
    }
}

