/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.demo.ancient.demo.swingicons;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.demo.ancient.demo.swingicons.IconTableModel;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SwingIconsDemoTableModel
extends IconTableModel {
    private static final Log logger = LogFactory.getLog(SwingIconsDemoTableModel.class);

    public SwingIconsDemoTableModel() {
    }

    public SwingIconsDemoTableModel(URL url) {
        if (url == null && (url = ObjectUtilities.getResource((String)"/jlfgr-1_0.jar", SwingIconsDemoTableModel.class)) == null) {
            logger.warn((Object)"Unable to find jlfgr-1_0.jar inside the classpath.\nUnable to load the icons.\nPlease make sure you have the Java Look and Feel Graphics Repository in your classpath.\nYou may download this jar-file from http://developer.java.sun.com/developer/techDocs/hi/repository.");
            return;
        }
        this.readData(url);
    }

    public boolean readData(URL url) {
        if (url == null) {
            throw new NullPointerException("URL given must not be null.");
        }
        this.clear();
        try {
            logger.debug((Object)("Open URL: " + url));
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            boolean retval = this.readData(in);
            ((InputStream)in).close();
            logger.debug((Object)("Loaded: " + this.getRowCount() + " icons"));
            return retval;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to load the Icons", (Throwable)e);
            return false;
        }
    }

    private boolean readData(InputStream in) {
        try {
            ZipInputStream iconJar = new ZipInputStream(in);
            ZipEntry ze = iconJar.getNextEntry();
            while (ze != null) {
                String fullName = ze.getName();
                if (fullName.endsWith(".gif")) {
                    String category = this.getCategory(fullName);
                    String name = this.getName(fullName);
                    Image image = this.getImage(iconJar);
                    Long bytes = new Long(ze.getSize());
                    this.addIconEntry(name, category, image, bytes);
                }
                iconJar.closeEntry();
                ze = iconJar.getNextEntry();
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to load the Icons", (Throwable)e);
            return false;
        }
        return true;
    }

    private Image getImage(InputStream in) {
        Image result = null;
        ByteArrayOutputStream byteIn = new ByteArrayOutputStream();
        try {
            IOUtils.getInstance().copyStreams(in, (OutputStream)byteIn);
            ImageIcon temp = new ImageIcon(byteIn.toByteArray());
            result = temp.getImage();
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to read the ZIP-Entry", (Throwable)e);
        }
        return result;
    }

    private String getCategory(String fullName) {
        int start = fullName.indexOf("/") + 1;
        int end = fullName.lastIndexOf("/");
        return fullName.substring(start, end);
    }

    private String getName(String fullName) {
        int start = fullName.lastIndexOf("/") + 1;
        int end = fullName.indexOf(".");
        return fullName.substring(start, end);
    }
}

